/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcMetadataFactory;
import io.trino.plugin.jdbc.JdbcTransactionHandle;
import io.trino.plugin.jdbc.TablePropertiesProvider;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class JdbcConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final JdbcMetadataFactory jdbcMetadataFactory;
    private final ConnectorSplitManager jdbcSplitManager;
    private final ConnectorRecordSetProvider jdbcRecordSetProvider;
    private final ConnectorPageSinkProvider jdbcPageSinkProvider;
    private final Optional<ConnectorAccessControl> accessControl;
    private final Set<Procedure> procedures;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final ConcurrentMap<ConnectorTransactionHandle, JdbcMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, JdbcMetadata>();

    @Inject
    public JdbcConnector(LifeCycleManager lifeCycleManager, JdbcMetadataFactory jdbcMetadataFactory, ConnectorSplitManager jdbcSplitManager, ConnectorRecordSetProvider jdbcRecordSetProvider, ConnectorPageSinkProvider jdbcPageSinkProvider, Optional<ConnectorAccessControl> accessControl, Set<Procedure> procedures, Set<SessionPropertiesProvider> sessionProperties, Set<TablePropertiesProvider> tableProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.jdbcMetadataFactory = Objects.requireNonNull(jdbcMetadataFactory, "jdbcMetadataFactory is null");
        this.jdbcSplitManager = Objects.requireNonNull(jdbcSplitManager, "jdbcSplitManager is null");
        this.jdbcRecordSetProvider = Objects.requireNonNull(jdbcRecordSetProvider, "jdbcRecordSetProvider is null");
        this.jdbcPageSinkProvider = Objects.requireNonNull(jdbcPageSinkProvider, "jdbcPageSinkProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.sessionProperties = (List)Objects.requireNonNull(sessionProperties, "sessionProperties is null").stream().flatMap(sessionPropertiesProvider -> sessionPropertiesProvider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
        this.tableProperties = (List)Objects.requireNonNull(tableProperties, "tableProperties is null").stream().flatMap(tablePropertiesProvider -> tablePropertiesProvider.getTableProperties().stream()).collect(ImmutableList.toImmutableList());
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        JdbcTransactionHandle transaction = new JdbcTransactionHandle();
        this.transactions.put(transaction, this.jdbcMetadataFactory.create(transaction));
        return transaction;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        JdbcMetadata metadata = (JdbcMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        JdbcMetadata metadata = (JdbcMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        metadata.rollback();
    }

    public ConnectorSplitManager getSplitManager() {
        return this.jdbcSplitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.jdbcRecordSetProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.jdbcPageSinkProvider;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return Sets.immutableEnumSet((Enum)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT, (Enum[])new ConnectorCapabilities[0]);
    }
}

