/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.plugin.jdbc.CaseSensitivity;
import java.util.Objects;
import java.util.Optional;

public final class JdbcTypeHandle {
    private final int jdbcType;
    private final Optional<String> jdbcTypeName;
    private final Optional<Integer> columnSize;
    private final Optional<Integer> decimalDigits;
    private final Optional<Integer> arrayDimensions;
    private final Optional<CaseSensitivity> caseSensitivity;

    @Deprecated
    public JdbcTypeHandle(int jdbcType, Optional<String> jdbcTypeName, int columnSize, int decimalDigits, Optional<Integer> arrayDimensions) {
        this(jdbcType, jdbcTypeName, columnSize, decimalDigits, arrayDimensions, Optional.empty());
    }

    @Deprecated
    public JdbcTypeHandle(int jdbcType, Optional<String> jdbcTypeName, int columnSize, int decimalDigits, Optional<Integer> arrayDimensions, Optional<CaseSensitivity> caseSensitivity) {
        this(jdbcType, jdbcTypeName, Optional.of(columnSize), Optional.of(decimalDigits), arrayDimensions, caseSensitivity);
    }

    @JsonCreator
    public JdbcTypeHandle(@JsonProperty(value="jdbcType") int jdbcType, @JsonProperty(value="jdbcTypeName") Optional<String> jdbcTypeName, @JsonProperty(value="columnSize") Optional<Integer> columnSize, @JsonProperty(value="decimalDigits") Optional<Integer> decimalDigits, @JsonProperty(value="arrayDimensions") Optional<Integer> arrayDimensions, @JsonProperty(value="caseSensitivity") Optional<CaseSensitivity> caseSensitivity) {
        this.jdbcType = jdbcType;
        this.jdbcTypeName = Objects.requireNonNull(jdbcTypeName, "jdbcTypeName is null");
        this.columnSize = Objects.requireNonNull(columnSize, "columnSize is null");
        this.decimalDigits = Objects.requireNonNull(decimalDigits, "decimalDigits is null");
        this.arrayDimensions = Objects.requireNonNull(arrayDimensions, "arrayDimensions is null");
        this.caseSensitivity = Objects.requireNonNull(caseSensitivity, "caseSensitivity is null");
    }

    @JsonProperty
    public int getJdbcType() {
        return this.jdbcType;
    }

    @JsonProperty
    public Optional<String> getJdbcTypeName() {
        return this.jdbcTypeName;
    }

    @JsonProperty
    public Optional<Integer> getColumnSize() {
        return this.columnSize;
    }

    @JsonIgnore
    public int getRequiredColumnSize() {
        return this.getColumnSize().orElseThrow(() -> new IllegalStateException("column size not present"));
    }

    @JsonProperty
    public Optional<Integer> getDecimalDigits() {
        return this.decimalDigits;
    }

    @JsonIgnore
    public int getRequiredDecimalDigits() {
        return this.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
    }

    @JsonProperty
    public Optional<Integer> getArrayDimensions() {
        return this.arrayDimensions;
    }

    @JsonProperty
    public Optional<CaseSensitivity> getCaseSensitivity() {
        return this.caseSensitivity;
    }

    public int hashCode() {
        return Objects.hash(this.jdbcType, this.jdbcTypeName, this.columnSize, this.decimalDigits, this.arrayDimensions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcTypeHandle that = (JdbcTypeHandle)o;
        return this.jdbcType == that.jdbcType && Objects.equals(this.columnSize, that.columnSize) && Objects.equals(this.decimalDigits, that.decimalDigits) && Objects.equals(this.jdbcTypeName, that.jdbcTypeName) && Objects.equals(this.arrayDimensions, that.arrayDimensions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("jdbcType", this.jdbcType).add("jdbcTypeName", this.jdbcTypeName.orElse(null)).add("columnSize", this.columnSize).add("decimalDigits", this.decimalDigits).add("arrayDimensions", this.arrayDimensions.orElse(null)).toString();
    }
}

