/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Match;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.expression.AggregateFunctionRule;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class AggregateFunctionRewriter {
    private final Function<String, String> identifierQuote;
    private final Set<AggregateFunctionRule> rules;

    public AggregateFunctionRewriter(Function<String, String> identifierQuote, Set<AggregateFunctionRule> rules) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        this.rules = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rules, "rules is null"));
    }

    public Optional<JdbcExpression> rewrite(final ConnectorSession session, AggregateFunction aggregateFunction, final Map<String, ColumnHandle> assignments) {
        Objects.requireNonNull(aggregateFunction, "aggregateFunction is null");
        Objects.requireNonNull(assignments, "assignments is null");
        AggregateFunctionRule.RewriteContext context = new AggregateFunctionRule.RewriteContext(){

            @Override
            public Map<String, ColumnHandle> getAssignments() {
                return assignments;
            }

            @Override
            public Function<String, String> getIdentifierQuote() {
                return AggregateFunctionRewriter.this.identifierQuote;
            }

            @Override
            public ConnectorSession getSession() {
                return session;
            }
        };
        for (AggregateFunctionRule rule : this.rules) {
            Iterator matches = rule.getPattern().match((Object)aggregateFunction, (Object)context).iterator();
            while (matches.hasNext()) {
                Match match = (Match)matches.next();
                Optional<JdbcExpression> rewritten = rule.rewrite(aggregateFunction, match.captures(), context);
                if (!rewritten.isPresent()) continue;
                return rewritten;
            }
        }
        return Optional.empty();
    }
}

