/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.AggregateFunctionPatterns;
import io.trino.plugin.jdbc.expression.AggregateFunctionRule;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import java.util.Objects;
import java.util.Optional;

public class ImplementCount
implements AggregateFunctionRule {
    private static final Capture<Variable> INPUT = Capture.newCapture();
    private final JdbcTypeHandle bigintTypeHandle;

    public ImplementCount(JdbcTypeHandle bigintTypeHandle) {
        this.bigintTypeHandle = Objects.requireNonNull(bigintTypeHandle, "bigintTypeHandle is null");
    }

    @Override
    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"count")).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().capturedAs(INPUT)));
    }

    @Override
    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        Variable input = (Variable)captures.get(INPUT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(input.getName());
        Verify.verify((aggregateFunction.getOutputType() == BigintType.BIGINT ? 1 : 0) != 0);
        return Optional.of(new JdbcExpression(String.format("count(%s)", context.getIdentifierQuote().apply(columnHandle.getColumnName())), this.bigintTypeHandle));
    }
}

