/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.AggregateFunctionPatterns;
import io.trino.plugin.jdbc.expression.AggregateFunctionRule;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.DecimalType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ImplementSum
implements AggregateFunctionRule {
    private static final Capture<Variable> INPUT = Capture.newCapture();
    private final Function<DecimalType, Optional<JdbcTypeHandle>> decimalTypeHandle;

    public ImplementSum(Function<DecimalType, Optional<JdbcTypeHandle>> decimalTypeHandle) {
        this.decimalTypeHandle = Objects.requireNonNull(decimalTypeHandle, "decimalTypeHandle is null");
    }

    @Override
    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"sum")).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().capturedAs(INPUT)));
    }

    @Override
    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        JdbcTypeHandle resultTypeHandle;
        Variable input = (Variable)captures.get(INPUT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(input.getName());
        if (columnHandle.getColumnType().equals(aggregateFunction.getOutputType())) {
            resultTypeHandle = columnHandle.getJdbcTypeHandle();
        } else if (aggregateFunction.getOutputType() instanceof DecimalType) {
            Optional<JdbcTypeHandle> decimalTypeHandle = this.decimalTypeHandle.apply((DecimalType)aggregateFunction.getOutputType());
            if (decimalTypeHandle.isEmpty()) {
                return Optional.empty();
            }
            resultTypeHandle = decimalTypeHandle.get();
        } else {
            return Optional.empty();
        }
        return Optional.of(new JdbcExpression(String.format("sum(%s)", context.getIdentifierQuote().apply(columnHandle.getColumnName())), resultTypeHandle));
    }
}

