/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.type.BooleanType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class RewriteComparison
implements ConnectorExpressionRule<Call, String> {
    private static final Capture<ConnectorExpression> LEFT = Capture.newCapture();
    private static final Capture<ConnectorExpression> RIGHT = Capture.newCapture();
    private final Pattern<Call> pattern;

    public RewriteComparison(Set<ComparisonOperator> enabledOperators) {
        Set functionNames = (Set)enabledOperators.stream().map(ComparisonOperator::getFunctionName).collect(ImmutableSet.toImmutableSet());
        this.pattern = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().matching(functionNames::contains)).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.expression().capturedAs(LEFT))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.expression().capturedAs(RIGHT)));
    }

    public Pattern<Call> getPattern() {
        return this.pattern;
    }

    public Optional<String> rewrite(Call call, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        Optional left = context.defaultRewrite((ConnectorExpression)captures.get(LEFT));
        if (left.isEmpty()) {
            return Optional.empty();
        }
        Optional right = context.defaultRewrite((ConnectorExpression)captures.get(RIGHT));
        if (right.isEmpty()) {
            return Optional.empty();
        }
        Verify.verify((boolean)call.getFunctionName().getCatalogSchema().isEmpty());
        ComparisonOperator operator = ComparisonOperator.forFunctionName(call.getFunctionName());
        return Optional.of(String.format("(%s) %s (%s)", left.get(), operator.getOperator(), right.get()));
    }

    public static enum ComparisonOperator {
        EQUAL(StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, "="),
        NOT_EQUAL(StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, "<>"),
        LESS_THAN(StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, "<"),
        LESS_THAN_OR_EQUAL(StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, "<="),
        GREATER_THAN(StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, ">"),
        GREATER_THAN_OR_EQUAL(StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, ">="),
        IS_DISTINCT_FROM(StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME, "IS DISTINCT FROM");

        private final FunctionName functionName;
        private final String operator;
        private static final Map<FunctionName, ComparisonOperator> OPERATOR_BY_FUNCTION_NAME;

        private ComparisonOperator(FunctionName functionName, String operator) {
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
        }

        private FunctionName getFunctionName() {
            return this.functionName;
        }

        private String getOperator() {
            return this.operator;
        }

        private static ComparisonOperator forFunctionName(FunctionName functionName) {
            return (ComparisonOperator)((Object)Verify.verifyNotNull((Object)((Object)OPERATOR_BY_FUNCTION_NAME.get(functionName)), (String)"Function name not recognized: %s", (Object[])new Object[]{functionName}));
        }

        static {
            OPERATOR_BY_FUNCTION_NAME = (Map)Stream.of(ComparisonOperator.values()).collect(ImmutableMap.toImmutableMap(ComparisonOperator::getFunctionName, Function.identity()));
        }
    }
}

