/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.type.BooleanType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class RewriteLogicalExpression
implements ConnectorExpressionRule<Call, String> {
    private final Pattern<Call> pattern;
    private final String operator;

    RewriteLogicalExpression(FunctionName functionName, String operator) {
        this.pattern = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)Objects.requireNonNull(functionName, "functionName is null"))).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN));
        this.operator = Objects.requireNonNull(operator, "operator is null");
    }

    public Pattern<Call> getPattern() {
        return this.pattern;
    }

    public Optional<String> rewrite(Call call, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        List arguments = call.getArguments();
        Verify.verify((!arguments.isEmpty() ? 1 : 0) != 0, (String)"no arguments", (Object[])new Object[0]);
        ArrayList<String> terms = new ArrayList<String>(arguments.size());
        for (ConnectorExpression argument : arguments) {
            Verify.verify((argument.getType() == BooleanType.BOOLEAN ? 1 : 0) != 0, (String)"Unexpected type of argument: %s", (Object)argument.getType());
            Optional rewritten = context.defaultRewrite(argument);
            if (rewritten.isEmpty()) {
                return Optional.empty();
            }
            terms.add((String)rewritten.get());
        }
        return Optional.of(terms.stream().collect(Collectors.joining(") " + this.operator + " (", "(", ")")));
    }
}

