/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.logging;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.trino.plugin.jdbc.logging.FormatBasedRemoteQueryModifier;
import java.util.Arrays;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.AssertTrue;

public class FormatBasedRemoteQueryModifierConfig {
    private static final List<String> PREDEFINED_MATCHES = Arrays.stream(FormatBasedRemoteQueryModifier.PredefinedValue.values()).map(FormatBasedRemoteQueryModifier.PredefinedValue::getMatchCase).toList();
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("[\\w ,=]|" + String.join((CharSequence)"|", PREDEFINED_MATCHES));
    private String format = "";

    @Config(value="query.comment-format")
    @ConfigDescription(value="Format in which logs about query execution context should be added as comments sent through jdbc driver.")
    public FormatBasedRemoteQueryModifierConfig setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    @AssertTrue(message="Incorrect format it may consist of only letters, digits, underscores, commas, spaces, equal signs and predefined values")
    @AssertTrue(message="Incorrect format it may consist of only letters, digits, underscores, commas, spaces, equal signs and predefined values") boolean isFormatValid() {
        Matcher matcher = VALIDATION_PATTERN.matcher(this.format);
        return matcher.results().map(MatchResult::group).collect(Collectors.joining()).equals(this.format);
    }
}

