/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.mapping;

import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.spi.security.ConnectorIdentity;
import java.sql.Connection;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class ForwardingIdentifierMapping
implements IdentifierMapping {
    public static IdentifierMapping of(final Supplier<IdentifierMapping> delegateSupplier) {
        Objects.requireNonNull(delegateSupplier, "delegateSupplier is null");
        return new ForwardingIdentifierMapping(){

            @Override
            protected IdentifierMapping delegate() {
                return (IdentifierMapping)delegateSupplier.get();
            }
        };
    }

    protected abstract IdentifierMapping delegate();

    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        return this.delegate().fromRemoteSchemaName(remoteSchemaName);
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        return this.delegate().fromRemoteTableName(remoteSchemaName, remoteTableName);
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return this.delegate().fromRemoteColumnName(remoteColumnName);
    }

    @Override
    public String toRemoteSchemaName(ConnectorIdentity identity, Connection connection, String schemaName) {
        return this.delegate().toRemoteSchemaName(identity, connection, schemaName);
    }

    @Override
    public String toRemoteTableName(ConnectorIdentity identity, Connection connection, String remoteSchema, String tableName) {
        return this.delegate().toRemoteTableName(identity, connection, remoteSchema, tableName);
    }

    @Override
    public String toRemoteColumnName(Connection connection, String columnName) {
        return this.delegate().toRemoteColumnName(connection, columnName);
    }
}

