/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.parquet.DataPage;
import io.trino.parquet.DataPageV1;
import io.trino.parquet.DataPageV2;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.AbstractColumnReader;
import io.trino.parquet.reader.ColumnChunk;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.parquet.reader.flat.DictionaryDecoder;
import io.trino.parquet.reader.flat.FlatDefinitionLevelDecoder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;

public class FlatColumnReader<BufferType>
extends AbstractColumnReader<BufferType> {
    private static final Logger log = Logger.get(FlatColumnReader.class);
    private static final int[] EMPTY_DEFINITION_LEVELS = new int[0];
    private static final int[] EMPTY_REPETITION_LEVELS = new int[0];
    private final FlatDefinitionLevelDecoder.DefinitionLevelDecoderProvider definitionLevelDecoderProvider;
    private final LocalMemoryContext memoryContext;
    private int remainingPageValueCount;
    private FlatDefinitionLevelDecoder definitionLevelDecoder;
    private ValueDecoder<BufferType> valueDecoder;
    private int readOffset;
    private int nextBatchSize;

    public FlatColumnReader(PrimitiveField field, ValueDecoder.ValueDecodersProvider<BufferType> decodersProvider, FlatDefinitionLevelDecoder.DefinitionLevelDecoderProvider definitionLevelDecoderProvider, DictionaryDecoder.DictionaryDecoderProvider<BufferType> dictionaryDecoderProvider, ColumnAdapter<BufferType> columnAdapter, LocalMemoryContext memoryContext) {
        super(field, decodersProvider, dictionaryDecoderProvider, columnAdapter);
        this.definitionLevelDecoderProvider = Objects.requireNonNull(definitionLevelDecoderProvider, "definitionLevelDecoderProvider is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
    }

    @Override
    public boolean hasPageReader() {
        return this.pageReader != null;
    }

    @Override
    protected boolean isNonNull() {
        return this.field.isRequired() || this.pageReader.hasNoNulls();
    }

    @Override
    public ColumnChunk readPrimitive() {
        this.seek();
        ColumnChunk columnChunk = this.isNonNull() ? this.readNonNull() : this.readNullable();
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return columnChunk;
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    private void seek() {
        if (this.readOffset > 0) {
            log.debug("seek field %s, readOffset %d, remainingPageValueCount %d", new Object[]{this.field, this.readOffset, this.remainingPageValueCount});
        }
        int remainingInBatch = this.readOffset;
        while (remainingInBatch > 0) {
            if (this.remainingPageValueCount == 0) {
                if ((remainingInBatch = this.seekToNextPage(remainingInBatch)) == 0) break;
                if (this.remainingPageValueCount == 0) {
                    FlatColumnReader.throwEndOfBatchException(remainingInBatch);
                }
            }
            int chunkSize = Math.min(this.remainingPageValueCount, remainingInBatch);
            int nonNullCount = this.isNonNull() ? chunkSize : this.definitionLevelDecoder.skip(chunkSize);
            this.valueDecoder.skip(nonNullCount);
            remainingInBatch -= this.rowRanges.seekForward(chunkSize);
            this.remainingPageValueCount -= chunkSize;
        }
    }

    @VisibleForTesting
    ColumnChunk readNullable() {
        log.debug("readNullable field %s, nextBatchSize %d, remainingPageValueCount %d", new Object[]{this.field, this.nextBatchSize, this.remainingPageValueCount});
        NullableValuesBuffer<BufferType> valuesBuffer = this.createNullableValuesBuffer(this.nextBatchSize);
        boolean[] isNull = new boolean[this.nextBatchSize];
        int remainingInBatch = this.nextBatchSize;
        int offset = 0;
        while (remainingInBatch > 0) {
            if (this.remainingPageValueCount == 0 && !this.readNextPage()) {
                FlatColumnReader.throwEndOfBatchException(remainingInBatch);
            }
            if (this.skipToRowRangesStart()) continue;
            int chunkSize = this.rowRanges.advanceRange(Math.min(this.remainingPageValueCount, remainingInBatch));
            int nonNullCount = this.definitionLevelDecoder.readNext(isNull, offset, chunkSize);
            valuesBuffer.readNullableValues(this.valueDecoder, isNull, offset, nonNullCount, chunkSize);
            offset += chunkSize;
            remainingInBatch -= chunkSize;
            this.remainingPageValueCount -= chunkSize;
        }
        return valuesBuffer.createNullableBlock(isNull, this.field.getType());
    }

    @VisibleForTesting
    ColumnChunk readNonNull() {
        log.debug("readNonNull field %s, nextBatchSize %d, remainingPageValueCount %d", new Object[]{this.field, this.nextBatchSize, this.remainingPageValueCount});
        NonNullValuesBuffer<BufferType> valuesBuffer = this.createNonNullValuesBuffer(this.nextBatchSize);
        int remainingInBatch = this.nextBatchSize;
        int offset = 0;
        while (remainingInBatch > 0) {
            if (this.remainingPageValueCount == 0 && !this.readNextPage()) {
                FlatColumnReader.throwEndOfBatchException(remainingInBatch);
            }
            if (this.skipToRowRangesStart()) continue;
            int chunkSize = this.rowRanges.advanceRange(Math.min(this.remainingPageValueCount, remainingInBatch));
            valuesBuffer.readNonNullValues(this.valueDecoder, offset, chunkSize);
            offset += chunkSize;
            remainingInBatch -= chunkSize;
            this.remainingPageValueCount -= chunkSize;
        }
        return valuesBuffer.createNonNullBlock(this.field.getType());
    }

    private boolean skipToRowRangesStart() {
        int skipCount = Math.toIntExact(this.rowRanges.skipToRangeStart());
        if (skipCount > 0) {
            log.debug("skipCount %d, remainingPageValueCount %d", new Object[]{skipCount, this.remainingPageValueCount});
        }
        if (skipCount >= this.remainingPageValueCount) {
            this.remainingPageValueCount = 0;
            return true;
        }
        if (skipCount > 0) {
            int nonNullsCount = this.isNonNull() ? skipCount : this.definitionLevelDecoder.skip(skipCount);
            this.valueDecoder.skip(nonNullsCount);
            this.remainingPageValueCount -= skipCount;
        }
        return false;
    }

    private boolean readNextPage() {
        if (!this.pageReader.hasNext()) {
            return false;
        }
        DataPage page = this.readPage();
        this.rowRanges.resetForNewPage(page.getFirstRowIndex());
        return true;
    }

    private int seekToNextPage(int remainingInBatch) {
        while (remainingInBatch > 0 && this.pageReader.hasNext()) {
            DataPage page = this.pageReader.getNextPage();
            this.rowRanges.resetForNewPage(page.getFirstRowIndex());
            if (remainingInBatch < page.getValueCount() || !this.rowRanges.isPageFullyConsumed(page.getValueCount())) {
                this.readPage();
                return remainingInBatch;
            }
            remainingInBatch -= page.getValueCount();
            this.remainingPageValueCount = 0;
            this.pageReader.skipNextPage();
        }
        return remainingInBatch;
    }

    private DataPage readPage() {
        DataPage page = this.pageReader.readPage();
        Objects.requireNonNull(page, "page is null");
        log.debug("readNextPage field %s, page %s", new Object[]{this.field, page});
        if (page instanceof DataPageV1) {
            DataPageV1 dataPageV1 = (DataPageV1)page;
            this.readFlatPageV1(dataPageV1);
        } else if (page instanceof DataPageV2) {
            DataPageV2 dataPageV2 = (DataPageV2)page;
            this.readFlatPageV2(dataPageV2);
        }
        int dataPageSizeInBytes = this.pageReader.arePagesCompressed() ? page.getUncompressedSize() : 0;
        long dictionarySizeInBytes = this.dictionaryDecoder == null ? 0L : this.dictionaryDecoder.getRetainedSizeInBytes();
        this.memoryContext.setBytes((long)dataPageSizeInBytes + dictionarySizeInBytes);
        this.remainingPageValueCount = page.getValueCount();
        return page;
    }

    private void readFlatPageV1(DataPageV1 page) {
        Slice buffer = page.getSlice();
        ParquetEncoding definitionEncoding = page.getDefinitionLevelEncoding();
        Preconditions.checkArgument((this.isNonNull() || definitionEncoding == ParquetEncoding.RLE ? 1 : 0) != 0, (String)"Invalid definition level encoding: %s", (Object)((Object)definitionEncoding));
        int alreadyRead = 0;
        if (definitionEncoding == ParquetEncoding.RLE) {
            int maxDefinitionLevel = this.field.getDescriptor().getMaxDefinitionLevel();
            this.definitionLevelDecoder = this.definitionLevelDecoderProvider.create(maxDefinitionLevel);
            if (maxDefinitionLevel > 0) {
                int bufferSize = buffer.getInt(0);
                this.definitionLevelDecoder.init(buffer.slice(4, bufferSize));
                alreadyRead = bufferSize + 4;
            }
        }
        this.valueDecoder = this.createValueDecoder(this.decodersProvider, page.getValueEncoding(), buffer.slice(alreadyRead, buffer.length() - alreadyRead));
    }

    private void readFlatPageV2(DataPageV2 page) {
        this.definitionLevelDecoder = this.definitionLevelDecoderProvider.create(this.field.getDescriptor().getMaxDefinitionLevel());
        this.definitionLevelDecoder.init(page.getDefinitionLevels());
        this.valueDecoder = this.createValueDecoder(this.decodersProvider, page.getDataEncoding(), page.getSlice());
    }

    private NonNullValuesBuffer<BufferType> createNonNullValuesBuffer(int batchSize) {
        if (this.produceDictionaryBlock()) {
            return new DictionaryValuesBuffer(this.field, this.dictionaryDecoder, batchSize);
        }
        return new DataValuesBuffer(this.field, this.columnAdapter, batchSize);
    }

    private NullableValuesBuffer<BufferType> createNullableValuesBuffer(int batchSize) {
        if (this.produceDictionaryBlock()) {
            return new DictionaryValuesBuffer(this.field, this.dictionaryDecoder, batchSize);
        }
        return new DataValuesBuffer(this.field, this.columnAdapter, batchSize);
    }

    private static interface NullableValuesBuffer<T> {
        public void readNullableValues(ValueDecoder<T> var1, boolean[] var2, int var3, int var4, int var5);

        public ColumnChunk createNullableBlock(boolean[] var1, Type var2);
    }

    private static interface NonNullValuesBuffer<T> {
        public void readNonNullValues(ValueDecoder<T> var1, int var2, int var3);

        public ColumnChunk createNonNullBlock(Type var1);
    }

    private static final class DictionaryValuesBuffer<T>
    implements NonNullValuesBuffer<T>,
    NullableValuesBuffer<T> {
        private final PrimitiveField field;
        private final DictionaryDecoder<T> decoder;
        private final int[] ids;
        private final int batchSize;
        private int totalNullsCount;

        private DictionaryValuesBuffer(PrimitiveField field, DictionaryDecoder<T> dictionaryDecoder, int batchSize) {
            this.field = field;
            this.ids = new int[batchSize];
            this.decoder = dictionaryDecoder;
            this.batchSize = batchSize;
        }

        @Override
        public void readNonNullValues(ValueDecoder<T> valueDecoder, int offset, int chunkSize) {
            this.decoder.readDictionaryIds(this.ids, offset, chunkSize);
        }

        @Override
        public void readNullableValues(ValueDecoder<T> valueDecoder, boolean[] isNull, int offset, int nonNullCount, int valuesCount) {
            if (nonNullCount == 0) {
                Arrays.fill(this.ids, offset, offset + valuesCount, this.decoder.getDictionarySize());
            } else if (nonNullCount == valuesCount) {
                this.decoder.readDictionaryIds(this.ids, offset, valuesCount);
            } else {
                int[] tmpBuffer = new int[nonNullCount];
                this.decoder.readDictionaryIds(tmpBuffer, 0, nonNullCount);
                FlatColumnReader.unpackDictionaryNullId(tmpBuffer, this.ids, isNull, offset, valuesCount, this.decoder.getDictionarySize());
            }
            this.totalNullsCount += valuesCount - nonNullCount;
        }

        @Override
        public ColumnChunk createNonNullBlock(Type type) {
            Preconditions.checkState((this.totalNullsCount == 0 ? 1 : 0) != 0, (String)"totalNonNullsCount %s should be equal to 0 when creating non-null block", (int)this.totalNullsCount);
            log.debug("DictionaryValuesBuffer createNonNullBlock field %s, totalNullsCount %d", new Object[]{this.field, this.totalNullsCount});
            return FlatColumnReader.createDictionaryBlock(this.ids, this.decoder.getDictionaryBlock(), EMPTY_DEFINITION_LEVELS, EMPTY_REPETITION_LEVELS);
        }

        @Override
        public ColumnChunk createNullableBlock(boolean[] isNull, Type type) {
            log.debug("DictionaryValuesBuffer createNullableBlock field %s, totalNullsCount %d, batchSize %d", new Object[]{this.field, this.totalNullsCount, this.batchSize});
            if (this.totalNullsCount == this.batchSize) {
                return new ColumnChunk(RunLengthEncodedBlock.create((Type)type, null, (int)this.batchSize), EMPTY_DEFINITION_LEVELS, EMPTY_REPETITION_LEVELS);
            }
            return FlatColumnReader.createDictionaryBlock(this.ids, this.decoder.getDictionaryBlock(), EMPTY_DEFINITION_LEVELS, EMPTY_REPETITION_LEVELS);
        }
    }

    private static final class DataValuesBuffer<T>
    implements NonNullValuesBuffer<T>,
    NullableValuesBuffer<T> {
        private final PrimitiveField field;
        private final ColumnAdapter<T> columnAdapter;
        private final T values;
        private final int batchSize;
        private int totalNullsCount;

        private DataValuesBuffer(PrimitiveField field, ColumnAdapter<T> columnAdapter, int batchSize) {
            this.field = field;
            this.values = columnAdapter.createBuffer(batchSize);
            this.columnAdapter = columnAdapter;
            this.batchSize = batchSize;
        }

        @Override
        public void readNonNullValues(ValueDecoder<T> valueDecoder, int offset, int valuesCount) {
            valueDecoder.read(this.values, offset, valuesCount);
        }

        @Override
        public void readNullableValues(ValueDecoder<T> valueDecoder, boolean[] isNull, int offset, int nonNullCount, int valuesCount) {
            if (nonNullCount == 0) {
                T tmpBuffer = this.columnAdapter.createTemporaryBuffer(offset, 0, this.values);
                this.columnAdapter.unpackNullValues(tmpBuffer, this.values, isNull, offset, 0, valuesCount);
            } else if (nonNullCount == valuesCount) {
                valueDecoder.read(this.values, offset, nonNullCount);
            } else {
                T tmpBuffer = this.columnAdapter.createTemporaryBuffer(offset, nonNullCount, this.values);
                valueDecoder.read(tmpBuffer, 0, nonNullCount);
                this.columnAdapter.unpackNullValues(tmpBuffer, this.values, isNull, offset, nonNullCount, valuesCount);
            }
            this.totalNullsCount += valuesCount - nonNullCount;
        }

        @Override
        public ColumnChunk createNonNullBlock(Type type) {
            Preconditions.checkState((this.totalNullsCount == 0 ? 1 : 0) != 0, (String)"totalNonNullsCount %s should be equal to 0 when creating non-null block", (int)this.totalNullsCount);
            log.debug("DataValuesBuffer createNonNullBlock field %s, totalNullsCount %d", new Object[]{this.field, this.totalNullsCount});
            return new ColumnChunk(this.columnAdapter.createNonNullBlock(this.values), EMPTY_DEFINITION_LEVELS, EMPTY_REPETITION_LEVELS);
        }

        @Override
        public ColumnChunk createNullableBlock(boolean[] isNull, Type type) {
            log.debug("DataValuesBuffer createNullableBlock field %s, totalNullsCount %d, batchSize %d", new Object[]{this.field, this.totalNullsCount, this.batchSize});
            if (this.totalNullsCount == this.batchSize) {
                return new ColumnChunk(RunLengthEncodedBlock.create((Type)type, null, (int)this.batchSize), EMPTY_DEFINITION_LEVELS, EMPTY_REPETITION_LEVELS);
            }
            if (this.totalNullsCount == 0) {
                return new ColumnChunk(this.columnAdapter.createNonNullBlock(this.values), EMPTY_DEFINITION_LEVELS, EMPTY_REPETITION_LEVELS);
            }
            return new ColumnChunk(this.columnAdapter.createNullableBlock(isNull, this.values), EMPTY_DEFINITION_LEVELS, EMPTY_REPETITION_LEVELS);
        }
    }
}

