/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.spark;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import io.trino.parquet.spark.VariantUtil;
import io.trino.plugin.base.util.JsonUtils;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Locale;

public final class Variant {
    private static final DateTimeFormatter TIMESTAMP_NTZ_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter(Locale.US);
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().append(TIMESTAMP_NTZ_FORMATTER).appendOffset("+HH:MM", "+00:00").toFormatter(Locale.US);
    private final byte[] value;
    private final byte[] metadata;
    private final int position;

    public Variant(byte[] value, byte[] metadata) {
        this(value, metadata, 0);
    }

    private Variant(byte[] value, byte[] metadata, int position) {
        this.value = value;
        this.metadata = metadata;
        this.position = position;
        Preconditions.checkArgument((metadata.length >= 1 ? 1 : 0) != 0, (Object)"metadata must be present");
        Preconditions.checkArgument(((metadata[0] & 0xF) == 1 ? 1 : 0) != 0, (String)"metadata version must be %s", (int)1);
        Preconditions.checkArgument((metadata.length <= 0x1000000 ? 1 : 0) != 0, (String)"max metadata size is %s: %s", (int)0x1000000, (int)metadata.length);
        Preconditions.checkArgument((value.length <= 0x1000000 ? 1 : 0) != 0, (String)"max value size is %s: %s", (int)0x1000000, (int)value.length);
    }

    public String toJson(ZoneId zoneId) {
        StringBuilder json = new StringBuilder();
        Variant.toJsonImpl(this.value, this.metadata, this.position, json, zoneId);
        return json.toString();
    }

    private static void toJsonImpl(byte[] value, byte[] metadata, int position, StringBuilder json, ZoneId zoneId) {
        switch (VariantUtil.getType(value, position)) {
            case NULL: {
                json.append("null");
                break;
            }
            case BOOLEAN: {
                json.append(VariantUtil.getBoolean(value, position));
                break;
            }
            case LONG: {
                json.append(VariantUtil.getLong(value, position));
                break;
            }
            case FLOAT: {
                json.append(VariantUtil.getFloat(value, position));
                break;
            }
            case DOUBLE: {
                json.append(VariantUtil.getDouble(value, position));
                break;
            }
            case DECIMAL: {
                json.append(VariantUtil.getDecimal(value, position).toPlainString());
                break;
            }
            case STRING: {
                json.append(Variant.escapeJson(VariantUtil.getString(value, position)));
                break;
            }
            case BINARY: {
                Variant.appendQuoted(json, Base64.getEncoder().encodeToString(VariantUtil.getBinary(value, position)));
                break;
            }
            case DATE: {
                Variant.appendQuoted(json, LocalDate.ofEpochDay(VariantUtil.getLong(value, position)).toString());
                break;
            }
            case TIMESTAMP: {
                Variant.appendQuoted(json, TIMESTAMP_FORMATTER.format(Variant.microsToInstant(VariantUtil.getLong(value, position)).atZone(zoneId)));
                break;
            }
            case TIMESTAMP_NTZ: {
                Variant.appendQuoted(json, TIMESTAMP_NTZ_FORMATTER.format(Variant.microsToInstant(VariantUtil.getLong(value, position)).atZone(ZoneOffset.UTC)));
                break;
            }
            case ARRAY: {
                VariantUtil.handleArray(value, position, (size, offsetSize, offsetStart, dataStart) -> {
                    json.append('[');
                    for (int i = 0; i < size; ++i) {
                        int offset = VariantUtil.readUnsigned(value, offsetStart + offsetSize * i, offsetSize);
                        int elementPos = dataStart + offset;
                        if (i != 0) {
                            json.append(',');
                        }
                        Variant.toJsonImpl(value, metadata, elementPos, json, zoneId);
                    }
                    json.append(']');
                    return null;
                });
                break;
            }
            case OBJECT: {
                VariantUtil.handleObject(value, position, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
                    json.append('{');
                    for (int i = 0; i < size; ++i) {
                        int id = VariantUtil.readUnsigned(value, idStart + idSize * i, idSize);
                        int offset = VariantUtil.readUnsigned(value, offsetStart + offsetSize * i, offsetSize);
                        int elementPosition = dataStart + offset;
                        if (i != 0) {
                            json.append(',');
                        }
                        json.append(Variant.escapeJson(VariantUtil.getMetadataKey(metadata, id)));
                        json.append(':');
                        Variant.toJsonImpl(value, metadata, elementPosition, json, zoneId);
                    }
                    json.append('}');
                    return null;
                });
            }
        }
    }

    private static Instant microsToInstant(long timestamp) {
        return Instant.EPOCH.plus(timestamp, ChronoUnit.MICROS);
    }

    private static void appendQuoted(StringBuilder json, String value) {
        json.append('\"').append(value).append('\"');
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String escapeJson(String value) {
        try (CharArrayWriter writer = new CharArrayWriter();){
            String string;
            block13: {
                JsonGenerator generator = JsonUtils.jsonFactory().createGenerator((Writer)writer);
                try {
                    generator.writeString(value);
                    generator.flush();
                    string = writer.toString();
                    if (generator == null) break block13;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

