/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.repdef;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.repdef.RepLevelWriterProvider;
import io.trino.parquet.writer.valuewriter.ColumnDescriptorValuesWriter;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.RowBlock;
import java.util.Objects;
import java.util.Optional;

public class RepLevelWriterProviders {
    private RepLevelWriterProviders() {
    }

    public static RepLevelWriterProvider of(Block block) {
        if (block.getUnderlyingValueBlock() instanceof RowBlock) {
            return new RowRepLevelWriterProvider(block);
        }
        return new PrimitiveRepLevelWriterProvider(block);
    }

    public static RepLevelWriterProvider of(ColumnarArray columnarArray, int maxRepetitionLevel) {
        return new ColumnArrayRepLevelWriterProvider(columnarArray, maxRepetitionLevel);
    }

    public static RepLevelWriterProvider of(ColumnarMap columnarMap, int maxRepetitionLevel) {
        return new ColumnMapRepLevelWriterProvider(columnarMap, maxRepetitionLevel);
    }

    private static void checkValidPosition(int offset, int positionsCount, int totalPositionsCount) {
        if (offset < 0 || positionsCount < 0 || offset + positionsCount > totalPositionsCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and positionsCount %s in block with %s positions", offset, positionsCount, totalPositionsCount));
        }
    }

    static class RowRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final Block block;

        RowRepLevelWriterProvider(Block block) {
            this.block = Objects.requireNonNull(block, "block is null");
            Preconditions.checkArgument((boolean)(block.getUnderlyingValueBlock() instanceof RowBlock), (Object)"block is not a row block");
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(final Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriterOptional, final ColumnDescriptorValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column row repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private final RepLevelWriterProvider.RepetitionLevelWriter nestedWriter;
                private int offset;
                final /* synthetic */ RowRepLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                    this.nestedWriter = (RepLevelWriterProvider.RepetitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, this.this$0.block.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.block.getPositionCount());
                    if (!this.this$0.block.mayHaveNull()) {
                        this.nestedWriter.writeRepetitionLevels(parentLevel, positionsCount);
                        this.offset += positionsCount;
                        return;
                    }
                    int position = this.offset;
                    while (position < this.offset + positionsCount) {
                        if (this.this$0.block.isNull(position)) {
                            encoder.writeInteger(parentLevel);
                            ++position;
                            continue;
                        }
                        int consecutiveNonNullsCount = 1;
                        ++position;
                        while (position < this.offset + positionsCount && !this.this$0.block.isNull(position)) {
                            ++position;
                            ++consecutiveNonNullsCount;
                        }
                        this.nestedWriter.writeRepetitionLevels(parentLevel, consecutiveNonNullsCount);
                    }
                    this.offset += positionsCount;
                }
            };
        }
    }

    static class PrimitiveRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final Block block;

        PrimitiveRepLevelWriterProvider(Block block) {
            this.block = Objects.requireNonNull(block, "block is null");
            Preconditions.checkArgument((!(block.getUnderlyingValueBlock() instanceof RowBlock) ? 1 : 0) != 0, (Object)"block is a row block");
            Preconditions.checkArgument((!(block.getUnderlyingValueBlock() instanceof ArrayBlock) ? 1 : 0) != 0, (Object)"block is an array block");
            Preconditions.checkArgument((!(block.getUnderlyingValueBlock() instanceof MapBlock) ? 1 : 0) != 0, (Object)"block is a map block");
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriter, final ColumnDescriptorValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriter.isEmpty(), (Object)"nestedWriter should be empty for primitive repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private int offset;
                final /* synthetic */ PrimitiveRepLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, this.this$0.block.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.block.getPositionCount());
                    encoder.writeRepeatInteger(parentLevel, positionsCount);
                    this.offset += positionsCount;
                }
            };
        }
    }

    static class ColumnArrayRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final ColumnarArray columnarArray;
        private final int maxRepetitionLevel;

        ColumnArrayRepLevelWriterProvider(ColumnarArray columnarArray, int maxRepetitionLevel) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxRepetitionLevel = maxRepetitionLevel;
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(final Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriterOptional, final ColumnDescriptorValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private final RepLevelWriterProvider.RepetitionLevelWriter nestedWriter;
                private int offset;
                final /* synthetic */ ColumnArrayRepLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                    this.nestedWriter = (RepLevelWriterProvider.RepetitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, this.this$0.columnarArray.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.columnarArray.getPositionCount());
                    if (!this.this$0.columnarArray.mayHaveNull()) {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (this.this$0.columnarArray.isNull(position)) {
                                encoder.writeInteger(parentLevel);
                                continue;
                            }
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    }
                    this.offset += positionsCount;
                }

                private void writeNonNullableLevels(int parentLevel, int position) {
                    int arrayLength = this.this$0.columnarArray.getLength(position);
                    if (arrayLength == 0) {
                        encoder.writeInteger(parentLevel);
                    } else {
                        this.nestedWriter.writeRepetitionLevels(parentLevel, 1);
                        this.nestedWriter.writeRepetitionLevels(this.this$0.maxRepetitionLevel, arrayLength - 1);
                    }
                }
            };
        }
    }

    static class ColumnMapRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final ColumnarMap columnarMap;
        private final int maxRepetitionLevel;

        ColumnMapRepLevelWriterProvider(ColumnarMap columnarMap, int maxRepetitionLevel) {
            this.columnarMap = Objects.requireNonNull(columnarMap, "columnarMap is null");
            this.maxRepetitionLevel = maxRepetitionLevel;
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(final Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriterOptional, final ColumnDescriptorValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private final RepLevelWriterProvider.RepetitionLevelWriter nestedWriter;
                private int offset;
                final /* synthetic */ ColumnMapRepLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                    this.nestedWriter = (RepLevelWriterProvider.RepetitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, this.this$0.columnarMap.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.columnarMap.getPositionCount());
                    if (!this.this$0.columnarMap.mayHaveNull()) {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (this.this$0.columnarMap.isNull(position)) {
                                encoder.writeInteger(parentLevel);
                                continue;
                            }
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    }
                    this.offset += positionsCount;
                }

                private void writeNonNullableLevels(int parentLevel, int position) {
                    int entryLength = this.this$0.columnarMap.getEntryCount(position);
                    if (entryLength == 0) {
                        encoder.writeInteger(parentLevel);
                    } else {
                        this.nestedWriter.writeRepetitionLevels(parentLevel, 1);
                        this.nestedWriter.writeRepetitionLevels(this.this$0.maxRepetitionLevel, entryLength - 1);
                    }
                }
            };
        }
    }
}

