/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.s3.S3FileSystemModule;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.ForJdbcDynamicFiltering;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcConnector;
import io.trino.plugin.jdbc.JdbcJoinPushdownSupportModule;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.JdbcSplitManager;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.redshift.RedshiftClient;
import io.trino.plugin.redshift.RedshiftConfig;
import io.trino.plugin.redshift.RedshiftSessionProperties;
import io.trino.plugin.redshift.RedshiftSplitManager;
import io.trino.plugin.redshift.RedshiftUnloadConnector;
import io.trino.plugin.redshift.RedshiftUnloadJdbcQueryEventListener;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.sql.Driver;
import java.util.Properties;

public class RedshiftClientModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(RedshiftConfig.class);
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(RedshiftClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(JdbcMetadataConfig.class, config -> config.setBulkListColumns(true));
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcStatisticsConfig.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, RedshiftSessionProperties.class);
        this.install((Module)new DecimalModule());
        this.install((Module)new JdbcJoinPushdownSupportModule());
        this.install(ConditionalModule.conditionalModule(RedshiftConfig.class, config -> config.getUnloadLocation().isPresent(), unloadBinder -> {
            this.install((Module)new S3FileSystemModule());
            unloadBinder.bind(JdbcSplitManager.class).in(Scopes.SINGLETON);
            unloadBinder.bind(Connector.class).to(RedshiftUnloadConnector.class).in(Scopes.SINGLETON);
            unloadBinder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)unloadBinder, JdbcQueryEventListener.class).addBinding().to(RedshiftUnloadJdbcQueryEventListener.class).in(Scopes.SINGLETON);
            OptionalBinder.newOptionalBinder((Binder)unloadBinder, (Key)Key.get(ConnectorSplitManager.class, ForJdbcDynamicFiltering.class)).setBinding().to(RedshiftSplitManager.class).in(Scopes.SINGLETON);
        }, jdbcBinder -> jdbcBinder.bind(Connector.class).to(JdbcConnector.class).in(Scopes.SINGLETON)));
    }

    @Singleton
    @Provides
    @ForBaseJdbc
    public static ConnectionFactory getConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) {
        Properties properties = new Properties();
        properties.put("reWriteBatchedInserts", "true");
        properties.put("reWriteBatchedInsertsSize", "512");
        return DriverConnectionFactory.builder((Driver)new com.amazon.redshift.Driver(), (String)config.getConnectionUrl(), (CredentialProvider)credentialProvider).setConnectionProperties(properties).setOpenTelemetry(openTelemetry).build();
    }
}

