/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.FileSystemS3;
import io.trino.plugin.jdbc.ForJdbcClient;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSessionProperties;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcSplitManager;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.redshift.RedshiftConfig;
import io.trino.plugin.redshift.RedshiftSessionProperties;
import io.trino.plugin.redshift.RedshiftUnloadSplitSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.VarbinaryType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class RedshiftSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(RedshiftSplitManager.class);
    private final JdbcClient jdbcClient;
    private final QueryBuilder queryBuilder;
    private final RemoteQueryModifier queryModifier;
    private final JdbcSplitManager jdbcSplitManager;
    private final Optional<String> unloadLocation;
    private final Optional<String> unloadAuthorization;
    private final ExecutorService executor;
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public RedshiftSplitManager(JdbcClient jdbcClient, QueryBuilder queryBuilder, RemoteQueryModifier queryModifier, JdbcSplitManager jdbcSplitManager, RedshiftConfig redshiftConfig, @FileSystemS3 TrinoFileSystemFactory fileSystemFactory, @ForJdbcClient ExecutorService executor) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder is null");
        this.queryModifier = Objects.requireNonNull(queryModifier, "queryModifier is null");
        this.jdbcSplitManager = Objects.requireNonNull(jdbcSplitManager, "jdbcSplitManager is null");
        this.unloadLocation = redshiftConfig.getUnloadLocation();
        this.unloadAuthorization = redshiftConfig.getUnloadIamRole();
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        if (table instanceof JdbcProcedureHandle) {
            return this.jdbcSplitManager.getSplits(transaction, session, table, dynamicFilter, constraint);
        }
        FixedSplitSource fallbackSplitSource = new FixedSplitSource((ConnectorSplit)new JdbcSplit(Optional.empty()));
        if (!RedshiftSessionProperties.isUnloadEnabled(session)) {
            return fallbackSplitSource;
        }
        JdbcTableHandle jdbcTable = (JdbcTableHandle)table;
        JdbcTableHandle jdbcTableHandle = JdbcDynamicFilteringSessionProperties.dynamicFilteringEnabled((ConnectorSession)session) ? jdbcTable.intersectedWithConstraint(dynamicFilter.getCurrentPredicate()) : jdbcTable;
        List columns = jdbcTableHandle.getColumns().orElseGet(() -> this.jdbcClient.getColumns(session, jdbcTableHandle.getRequiredNamedRelation().getSchemaTableName(), jdbcTableHandle.getRequiredNamedRelation().getRemoteTableName()));
        if (!RedshiftSplitManager.isUnloadSupported(jdbcTable, columns)) {
            log.debug("Unsupported query shape detected. Falling back to using JDBC");
            return fallbackSplitSource;
        }
        return new RedshiftUnloadSplitSource(this.executor, session, this.jdbcClient, jdbcTableHandle, columns, this.queryBuilder, this.queryModifier, this.unloadLocation.orElseThrow(), this.unloadAuthorization, this.fileSystemFactory.create(session));
    }

    private static boolean isUnloadSupported(JdbcTableHandle table, List<JdbcColumnHandle> columns) {
        if (table.getColumns().isPresent() && ((List)table.getColumns().get()).isEmpty()) {
            return false;
        }
        if (RedshiftSplitManager.containsUnsupportedType(columns)) {
            return false;
        }
        if (table.getLimit().isPresent()) {
            return false;
        }
        return !RedshiftSplitManager.containsFilterConditionOnDecimalTypeColumn(table);
    }

    private static boolean containsUnsupportedType(List<JdbcColumnHandle> columns) {
        return columns.stream().anyMatch(column -> column.getColumnType() instanceof TimeType || column.getColumnType() instanceof VarbinaryType);
    }

    private static boolean containsFilterConditionOnDecimalTypeColumn(JdbcTableHandle table) {
        if (table.getConstraint().getDomains().map(domains -> domains.keySet().stream().anyMatch(column -> ((JdbcColumnHandle)column).getColumnType() instanceof DecimalType)).orElse(false).booleanValue()) {
            return true;
        }
        return table.getConstraintExpressions().stream().flatMap(expression -> expression.parameters().stream()).anyMatch(parameter -> parameter.getType() instanceof DecimalType);
    }
}

