/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.amazon.redshift.jdbc.RedshiftPreparedStatement;
import com.amazon.redshift.util.RedshiftException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.redshift.RedshiftErrorCode;
import io.trino.plugin.redshift.RedshiftUnloadSplit;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.metrics.Metrics;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class RedshiftUnloadSplitSource
implements ConnectorSplitSource {
    private static final Logger log = Logger.get(RedshiftUnloadSplitSource.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private final JdbcClient jdbcClient;
    private final QueryBuilder queryBuilder;
    private final RemoteQueryModifier queryModifier;
    private final Optional<String> unloadAuthorization;
    private final String unloadOutputPath;
    private final TrinoFileSystem fileSystem;
    private final CompletableFuture<Void> resultSetFuture;
    private List<FileInfo> unloadedFilePaths = ImmutableList.of();
    private boolean finished;

    public RedshiftUnloadSplitSource(ExecutorService executor, ConnectorSession session, JdbcClient jdbcClient, JdbcTableHandle jdbcTableHandle, List<JdbcColumnHandle> columns, QueryBuilder queryBuilder, RemoteQueryModifier queryModifier, String unloadLocation, Optional<String> unloadAuthorization, TrinoFileSystem fileSystem) {
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(session, "session is null");
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        Objects.requireNonNull(jdbcTableHandle, "jdbcTableHandle is null");
        Objects.requireNonNull(columns, "columns is null");
        this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder is null");
        this.queryModifier = Objects.requireNonNull(queryModifier, "queryModifier is null");
        this.unloadAuthorization = Objects.requireNonNull(unloadAuthorization, "unloadAuthorization is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        String queryFragmentId = session.getQueryId() + "/" + String.valueOf(UUID.randomUUID());
        this.unloadOutputPath = unloadLocation + "/" + queryFragmentId + "/";
        this.resultSetFuture = CompletableFuture.runAsync(() -> {
            try (Connection connection = jdbcClient.getConnection(session);){
                String redshiftSelectSql = this.buildRedshiftSelectSql(session, connection, jdbcTableHandle, columns);
                try (PreparedStatement statement = this.buildRedshiftUnloadSql(session, connection, columns, redshiftSelectSql, this.unloadOutputPath);){
                    connection.setReadOnly(false);
                    log.debug("Executing: %s", new Object[]{statement});
                    long start = System.nanoTime();
                    statement.execute();
                    log.info("Redshift UNLOAD command for %s query took %s", new Object[]{queryFragmentId, Duration.nanosSince((long)start)});
                }
            }
            catch (SQLException e) {
                if (e instanceof RedshiftException && e.getMessage() != null && e.getMessage().contains("The S3 bucket addressed by the query is in a different region from this cluster")) {
                    throw new TrinoException((ErrorCodeSupplier)RedshiftErrorCode.REDSHIFT_S3_CROSS_REGION_UNSUPPORTED, "Redshift cluster and S3 bucket in different regions is not supported", (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }, executor);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        return this.resultSetFuture.thenApply(void_ -> {
            this.unloadedFilePaths = this.readUnloadedFilePaths();
            ConnectorSplitSource.ConnectorSplitBatch connectorSplitBatch = new ConnectorSplitSource.ConnectorSplitBatch((List)this.unloadedFilePaths.stream().map(fileInfo -> new RedshiftUnloadSplit(fileInfo.path, fileInfo.size)).collect(ImmutableList.toImmutableList()), true);
            this.finished = true;
            return connectorSplitBatch;
        });
    }

    public void close() {
        this.resultSetFuture.cancel(true);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Metrics getMetrics() {
        if (this.unloadedFilePaths.isEmpty()) {
            return Metrics.EMPTY;
        }
        Map metrics = (Map)this.unloadedFilePaths.stream().collect(ImmutableMap.toImmutableMap(FileInfo::path, fileInfo -> new LongCount(fileInfo.size())));
        return new Metrics(metrics);
    }

    private String buildRedshiftSelectSql(ConnectorSession session, Connection connection, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        String selectQuerySql;
        PreparedQuery preparedQuery = this.jdbcClient.prepareQuery(session, table, Optional.empty(), columns, (Map)ImmutableMap.of());
        try (PreparedStatement openTelemetryPreparedStatement = this.queryBuilder.prepareStatement(this.jdbcClient, session, connection, preparedQuery, Optional.of(columns.size()));){
            RedshiftPreparedStatement redshiftPreparedStatement = openTelemetryPreparedStatement.unwrap(RedshiftPreparedStatement.class);
            selectQuerySql = redshiftPreparedStatement.toString();
        }
        return this.queryModifier.apply(session, selectQuerySql);
    }

    private PreparedStatement buildRedshiftUnloadSql(ConnectorSession session, Connection connection, List<JdbcColumnHandle> columns, String redshiftSelectSql, String unloadOutputPath) throws SQLException {
        Object[] objectArray = new Object[3];
        objectArray[0] = RedshiftUnloadSplitSource.escapeUnloadIllegalCharacters(redshiftSelectSql);
        objectArray[1] = unloadOutputPath;
        String string = "'%s'";
        objectArray[2] = this.unloadAuthorization.map(arg_0 -> RedshiftUnloadSplitSource.lambda$buildRedshiftUnloadSql$0("'%s'", arg_0)).orElse("DEFAULT");
        String unloadSql = "UNLOAD ('%s') TO '%s' IAM_ROLE %s FORMAT PARQUET MAXFILESIZE 64MB MANIFEST VERBOSE".formatted(objectArray);
        return this.queryBuilder.prepareStatement(this.jdbcClient, session, connection, new PreparedQuery(unloadSql, List.of()), Optional.of(columns.size()));
    }

    private List<FileInfo> readUnloadedFilePaths() {
        JsonNode outputFileEntries;
        Location manifestLocation = Location.of((String)(this.unloadOutputPath + "manifest"));
        TrinoInputFile inputFile = this.fileSystem.newInputFile(manifestLocation);
        try (TrinoInputStream inputStream = inputFile.newStream();){
            byte[] manifestContent = inputStream.readAllBytes();
            outputFileEntries = OBJECT_MAPPER.readTree(manifestContent).path("entries");
        }
        catch (FileNotFoundException e) {
            return ImmutableList.of();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RedshiftErrorCode.REDSHIFT_FILESYSTEM_ERROR, (Throwable)e);
        }
        ImmutableList.Builder unloadedFilePaths = ImmutableList.builder();
        outputFileEntries.elements().forEachRemaining(fileInfo -> unloadedFilePaths.add((Object)new FileInfo(fileInfo.get("url").asText(), fileInfo.get("meta").get("content_length").longValue())));
        return unloadedFilePaths.build();
    }

    private static String escapeUnloadIllegalCharacters(String value) {
        return value.replace("'", "''").replace("\\b", "\\\\b");
    }

    private static /* synthetic */ String lambda$buildRedshiftUnloadSql$0(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }

    private record FileInfo(String path, long size) {
    }
}

