/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.util.AsciiTable;

public abstract class ExperimentalJdbc
implements ExperimentalDatabase {
    protected Connection connection;
    protected final ArrayList<String> batch = new ArrayList();
    protected MetaData metaData;

    @Override
    public boolean canCreateJdbcDataSource() {
        return true;
    }

    @Override
    public void addToBatch(String executionUnit) {
        this.batch.add(executionUnit);
    }

    @Override
    public void doExecute(String executionUnit, boolean outputQueryResults) {
        try (Statement statement = this.connection.createStatement();){
            boolean hasResult = statement.execute(executionUnit);
            this.parseResults(hasResult, statement, outputQueryResults);
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public void doExecuteBatch() {
        if (this.batch.isEmpty()) {
            return;
        }
        try (Statement statement = this.connection.createStatement();){
            for (String sql : this.batch) {
                statement.addBatch(sql);
            }
            statement.executeBatch();
            this.batch.clear();
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public int getBatchSize() {
        return this.batch.size();
    }

    @Override
    public String getCurrentUser() {
        try {
            return JdbcUtils.getDatabaseMetaData(this.connection).getUserName();
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return this.connection != null && this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.isClosed()) {
            this.connection.close();
        }
    }

    protected boolean queryBoolean(String sql) {
        boolean bl;
        block8: {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(sql);
                resultSet.next();
                bl = resultSet.getBoolean(1);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new FlywayException(e);
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryForStringList(String query) throws SQLException {
        ArrayList<String> result;
        ResultSet resultSet = null;
        try (Statement statement = this.connection.createStatement();){
            resultSet = statement.executeQuery(query);
            result = new ArrayList<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return result;
    }

    private void parseResults(boolean hasResults, Statement statement, boolean outputQueryResult) throws SQLException {
        if (outputQueryResult) {
            while (hasResults || statement.getUpdateCount() != -1) {
                if (hasResults) {
                    ArrayList<List<String>> data;
                    ArrayList<String> columns;
                    try (ResultSet resultSet = statement.getResultSet();){
                        columns = new ArrayList<String>();
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        int columnCount = metadata.getColumnCount();
                        for (int i = 1; i <= columnCount; ++i) {
                            columns.add(metadata.getColumnName(i));
                        }
                        data = new ArrayList<List<String>>();
                        while (resultSet.next()) {
                            ArrayList<String> row = new ArrayList<String>();
                            for (int i = 1; i <= columnCount; ++i) {
                                row.add(resultSet.getString(i));
                            }
                            data.add(row);
                        }
                    }
                    this.outputResult(new Result(-1L, columns, data, ""));
                }
                hasResults = statement.getMoreResults();
            }
        }
    }

    private void outputResult(Result result) {
        if (result.columns() != null && !result.columns().isEmpty()) {
            LOG.info(new AsciiTable(result.columns(), result.data(), true, "", "No rows returned").render());
        }
    }
}

