/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.ResourceGroupSelector;
import io.trino.plugin.resourcegroups.SelectorResourceEstimate;
import io.trino.plugin.resourcegroups.VariableMap;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticSelector
implements ResourceGroupSelector {
    private static final Pattern NAMED_GROUPS_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private static final String USER_VARIABLE = "USER";
    private static final String SOURCE_VARIABLE = "SOURCE";
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> userGroupRegex;
    private final Optional<Pattern> sourceRegex;
    private final Set<String> clientTags;
    private final Optional<SelectorResourceEstimate> selectorResourceEstimate;
    private final Optional<String> queryType;
    private final ResourceGroupIdTemplate group;
    private final Set<String> variableNames;

    public StaticSelector(Optional<Pattern> userRegex, Optional<Pattern> userGroupRegex, Optional<Pattern> sourceRegex, Optional<List<String>> clientTags, Optional<SelectorResourceEstimate> selectorResourceEstimate, Optional<String> queryType, ResourceGroupIdTemplate group) {
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.userGroupRegex = Objects.requireNonNull(userGroupRegex, "userGroupRegex is null");
        this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        Objects.requireNonNull(clientTags, "clientTags is null");
        this.clientTags = ImmutableSet.copyOf((Collection)clientTags.orElse((List<String>)ImmutableList.of()));
        this.selectorResourceEstimate = Objects.requireNonNull(selectorResourceEstimate, "selectorResourceEstimate is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.group = Objects.requireNonNull(group, "group is null");
        HashSet variableNames = new HashSet(ImmutableList.of((Object)USER_VARIABLE, (Object)SOURCE_VARIABLE));
        userRegex.ifPresent(u -> StaticSelector.addNamedGroups(u, variableNames));
        sourceRegex.ifPresent(s -> StaticSelector.addNamedGroups(s, variableNames));
        this.variableNames = ImmutableSet.copyOf(variableNames);
        Sets.SetView unresolvedVariables = Sets.difference(group.getVariableNames(), variableNames);
        Preconditions.checkArgument((boolean)unresolvedVariables.isEmpty(), (String)"unresolved variables %s in resource group ID '%s', available: %s\"", (Object)unresolvedVariables, (Object)group, variableNames);
    }

    @Override
    public Optional<SelectionContext<ResourceGroupIdTemplate>> match(SelectionCriteria criteria) {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (this.userRegex.isPresent()) {
            Matcher userMatcher = this.userRegex.get().matcher(criteria.getUser());
            if (!userMatcher.matches()) {
                return Optional.empty();
            }
            this.addVariableValues(this.userRegex.get(), criteria.getUser(), variables);
        }
        if (this.userGroupRegex.isPresent() && criteria.getUserGroups().stream().noneMatch(group -> this.userGroupRegex.get().matcher((CharSequence)group).matches())) {
            return Optional.empty();
        }
        if (this.sourceRegex.isPresent()) {
            String source = criteria.getSource().orElse("");
            if (!this.sourceRegex.get().matcher(source).matches()) {
                return Optional.empty();
            }
            this.addVariableValues(this.sourceRegex.get(), source, variables);
        }
        if (!this.clientTags.isEmpty() && !criteria.getTags().containsAll(this.clientTags)) {
            return Optional.empty();
        }
        if (this.selectorResourceEstimate.isPresent() && !this.selectorResourceEstimate.get().match(criteria.getResourceEstimates())) {
            return Optional.empty();
        }
        if (this.queryType.isPresent()) {
            String contextQueryType = criteria.getQueryType().orElse("");
            if (!this.queryType.get().equalsIgnoreCase(contextQueryType)) {
                return Optional.empty();
            }
        }
        variables.putIfAbsent(USER_VARIABLE, criteria.getUser());
        variables.putIfAbsent(SOURCE_VARIABLE, criteria.getSource().orElse(""));
        ResourceGroupId id = this.group.expandTemplate(new VariableMap(variables));
        return Optional.of(new SelectionContext(id, (Object)this.group));
    }

    private static void addNamedGroups(Pattern pattern, HashSet<String> variables) {
        Matcher matcher = NAMED_GROUPS_PATTERN.matcher(pattern.toString());
        while (matcher.find()) {
            String name = matcher.group(1);
            Preconditions.checkArgument((!variables.contains(name) ? 1 : 0) != 0, (Object)("Multiple definitions found for variable ${" + name + "}"));
            variables.add(name);
        }
    }

    private void addVariableValues(Pattern pattern, String candidate, Map<String, String> mapping) {
        for (String key : this.variableNames) {
            Matcher keyMatcher = pattern.matcher(candidate);
            if (!keyMatcher.find()) continue;
            try {
                String value = keyMatcher.group(key);
                if (value == null) continue;
                mapping.put(key, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @VisibleForTesting
    public Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }
}

