/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import io.airlift.units.DataSize;
import io.trino.plugin.resourcegroups.FileResourceGroupConfig;
import io.trino.plugin.resourcegroups.FileResourceGroupConfigurationManager;
import io.trino.plugin.resourcegroups.ManagerSpec;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.SelectorSpec;
import io.trino.plugin.resourcegroups.TestingResourceGroup;
import io.trino.plugin.resourcegroups.TestingResourceGroups;
import io.trino.spi.memory.MemoryPoolInfo;
import io.trino.spi.resourcegroups.ResourceGroup;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import io.trino.spi.session.ResourceEstimates;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestFileResourceGroupConfigurationManager {
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());
    private static final long MEMORY_POOL_SIZE = 31415926535900L;

    @Test
    public void testInvalid() {
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_root.json", "Duplicated root group: global");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_sub_group.json", "Duplicated sub group: sub");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_group_id.json", "Invalid resource group name. 'glo.bal' contains a '.'");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_soft_memory_limit.json", "softMemoryLimit percentage is over 100%");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_weighted_scheduling_policy.json", "Must specify scheduling weight for all sub-groups of 'requests' or none of them");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_unused_field.json", "Unknown property at line 8:6: maxFoo");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_query_priority_scheduling_policy.json", "Must use 'weighted' or 'weighted_fair' scheduling policy if specifying scheduling weight for 'requests'");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_extract_variable.json", "Invalid resource group name.*");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_query_type.json", "Selector specifies an invalid query type: invalid_query_type");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_selector.json", "Selector refers to nonexistent group: a.b.c.X");
    }

    @Test
    public void testQueryTypeConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config_query_type.json");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("select"), "global.select");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("explain"), "global.explain");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("insert"), "global.insert");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("delete"), "global.delete");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("describe"), "global.describe");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("data_definition"), "global.data_definition");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("sth_else"), "global.other");
    }

    @Test
    public void testMatchByUserGroups() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).userGroups("first matching", "second matching")));
        FileResourceGroupConfigurationManager groupManager = new FileResourceGroupConfigurationManager(listener -> {}, managerSpec);
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userGroupsSelectionCriteria("not matching"))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userGroupsSelectionCriteria("first matching"))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testMatchByUsers() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).users("First matching user", "Second matching user")));
        FileResourceGroupConfigurationManager groupManager = new FileResourceGroupConfigurationManager(listener -> {}, managerSpec);
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userSelectionCriteria("Not matching user"))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userSelectionCriteria("First matching user"))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testMatchByUsersAndGroups() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).userGroups("Matching group").users("Matching user")));
        FileResourceGroupConfigurationManager groupManager = new FileResourceGroupConfigurationManager(listener -> {}, managerSpec);
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Matching user", "Not matching group", new String[0]))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Not matching user", "Matching group", new String[0]))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Matching user", "Matching group", new String[0]))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testMatchByOriginalUser() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).originalUserPattern("foo.+")));
        FileResourceGroupConfigurationManager manager = new FileResourceGroupConfigurationManager(listener -> {}, managerSpec);
        Assertions.assertThat((Optional)manager.match(TestFileResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "other-usr", Optional.empty()))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestFileResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "other-usr", Optional.of("foo-usr")))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestFileResourceGroupConfigurationManager.identitySelectionCriteria("other-usr", "foo-usr", Optional.empty()))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testMatchByAuthenticatedUser() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).authenticatedUserPattern("foo.+")));
        FileResourceGroupConfigurationManager manager = new FileResourceGroupConfigurationManager(listener -> {}, managerSpec);
        Assertions.assertThat((Optional)manager.match(TestFileResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "foo-usr", Optional.empty()))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestFileResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "foo-usr", Optional.of("other-usr")))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestFileResourceGroupConfigurationManager.identitySelectionCriteria("other-usr", "other-usr", Optional.of("foo-usr")))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testUserGroupsConfiguration() {
        ManagerSpec spec = TestFileResourceGroupConfigurationManager.parseManagerSpec("resource_groups_config_user_groups.json");
        Assertions.assertThat(spec.getSelectors().stream().map(SelectorSpec::getUserGroupRegex).map(pattern -> pattern.map(Pattern::pattern))).containsOnly((Object[])new Optional[]{Optional.of("groupA")});
    }

    @Test
    public void testOriginalAndAuthenticatedUserConfiguration() {
        ManagerSpec spec = TestFileResourceGroupConfigurationManager.parseManagerSpec("resource_groups_config_original_auth_user.json");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)spec.getSelectors()).hasSize(2)).anySatisfy(selector -> {
            Assertions.assertThat((Object)selector.getGroup()).hasToString("global.original");
            Assertions.assertThat(selector.getOriginalUserRegex().map(Pattern::pattern)).contains((Object)"usr-original");
            Assertions.assertThat((Optional)selector.getAuthenticatedUserRegex()).isEmpty();
        })).anySatisfy(selector -> {
            Assertions.assertThat((Object)selector.getGroup()).hasToString("global.auth");
            Assertions.assertThat((Optional)selector.getOriginalUserRegex()).isEmpty();
            Assertions.assertThat(selector.getAuthenticatedUserRegex().map(Pattern::pattern)).contains((Object)"usr-auth");
        });
    }

    @Test
    public void testConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config.json");
        ResourceGroupId globalId = new ResourceGroupId("global");
        TestingResourceGroup global = new TestingResourceGroup(globalId);
        manager.configure((ResourceGroup)global, new SelectionContext(globalId, (Object)new ResourceGroupIdTemplate("global")));
        Assertions.assertThat((long)global.getSoftMemoryLimitBytes()).isEqualTo(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assertions.assertThat((Duration)global.getSoftCpuLimit()).isEqualTo((Object)Duration.ofHours(1L));
        Assertions.assertThat((Duration)global.getHardCpuLimit()).isEqualTo((Object)Duration.ofDays(1L));
        Assertions.assertThat((long)global.getCpuQuotaGenerationMillisPerSecond()).isEqualTo(24000L);
        Assertions.assertThat((int)global.getMaxQueuedQueries()).isEqualTo(1000);
        Assertions.assertThat((int)global.getHardConcurrencyLimit()).isEqualTo(100);
        Assertions.assertThat((Comparable)global.getSchedulingPolicy()).isEqualTo((Object)SchedulingPolicy.WEIGHTED);
        Assertions.assertThat((int)global.getSchedulingWeight()).isEqualTo(0);
        Assertions.assertThat((boolean)global.getJmxExport()).isTrue();
        ResourceGroupId subId = new ResourceGroupId(globalId, "sub");
        TestingResourceGroup sub = new TestingResourceGroup(subId);
        manager.configure((ResourceGroup)sub, new SelectionContext(subId, (Object)new ResourceGroupIdTemplate("global.sub")));
        Assertions.assertThat((long)sub.getSoftMemoryLimitBytes()).isEqualTo(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assertions.assertThat((int)sub.getHardConcurrencyLimit()).isEqualTo(3);
        Assertions.assertThat((int)sub.getMaxQueuedQueries()).isEqualTo(4);
        Assertions.assertThat((Comparable)sub.getSchedulingPolicy()).isNull();
        Assertions.assertThat((int)sub.getSchedulingWeight()).isEqualTo(5);
        Assertions.assertThat((boolean)sub.getJmxExport()).isFalse();
        ResourceGroupId subIdNoSoftMemoryLimit = new ResourceGroupId(globalId, "sub_no_soft_memory_limit");
        TestingResourceGroup subNoSoftMemoryLimit = new TestingResourceGroup(subIdNoSoftMemoryLimit);
        manager.configure((ResourceGroup)subNoSoftMemoryLimit, new SelectionContext(subIdNoSoftMemoryLimit, (Object)new ResourceGroupIdTemplate("global.sub_no_soft_memory_limit")));
        Assertions.assertThat((long)subNoSoftMemoryLimit.getSoftMemoryLimitBytes()).isEqualTo(31415926535900L);
        Assertions.assertThat((int)subNoSoftMemoryLimit.getHardConcurrencyLimit()).isEqualTo(4);
        Assertions.assertThat((int)subNoSoftMemoryLimit.getSchedulingWeight()).isEqualTo(1);
    }

    @Test
    public void testExtractVariableConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config_extract_variable.json");
        SelectionContext<ResourceGroupIdTemplate> selectionContext = TestFileResourceGroupConfigurationManager.match(manager, TestFileResourceGroupConfigurationManager.userAndSourceSelectionCriteria("someuser@presto.io", "scheduler.us_east.12"));
        Assertions.assertThat((String)selectionContext.getResourceGroupId().toString()).isEqualTo("global.presto:us_east:12");
        TestingResourceGroup resourceGroup = new TestingResourceGroup(selectionContext.getResourceGroupId());
        manager.configure((ResourceGroup)resourceGroup, selectionContext);
        Assertions.assertThat((int)resourceGroup.getHardConcurrencyLimit()).isEqualTo(3);
        selectionContext = TestFileResourceGroupConfigurationManager.match(manager, TestFileResourceGroupConfigurationManager.userAndSourceSelectionCriteria("nobody", "rg-abcdefghijkl"));
        Assertions.assertThat((String)selectionContext.getResourceGroupId().toString()).isEqualTo("global.abcdefghijkl");
        resourceGroup = new TestingResourceGroup(selectionContext.getResourceGroupId());
        manager.configure((ResourceGroup)resourceGroup, selectionContext);
        Assertions.assertThat((int)resourceGroup.getHardConcurrencyLimit()).isEqualTo(115);
    }

    @Test
    public void testDocsExample() {
        FileResourceGroupConfigurationManager manager = new FileResourceGroupConfigurationManager(listener -> listener.accept(new MemoryPoolInfo(31415926535900L, 0L, 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of())), new FileResourceGroupConfig().setConfigFile("../../docs/src/main/sphinx/admin/resource-groups-example.json"));
        SelectionContext<ResourceGroupIdTemplate> selectionContext = TestFileResourceGroupConfigurationManager.match(manager, new SelectionCriteria(true, "Alice", (Set)ImmutableSet.of(), "Alice", Optional.empty(), Optional.of("jdbc#powerfulbi"), (Set)ImmutableSet.of((Object)"hipri"), EMPTY_RESOURCE_ESTIMATES, Optional.of("select")));
        Assertions.assertThat((String)selectionContext.getResourceGroupId().toString()).isEqualTo("global.adhoc.bi-powerfulbi.Alice");
        TestingResourceGroup resourceGroup = new TestingResourceGroup(selectionContext.getResourceGroupId());
        manager.configure((ResourceGroup)resourceGroup, selectionContext);
        Assertions.assertThat((int)resourceGroup.getHardConcurrencyLimit()).isEqualTo(3);
        Assertions.assertThat((int)resourceGroup.getMaxQueuedQueries()).isEqualTo(10);
        Assertions.assertThat((long)resourceGroup.getSoftMemoryLimitBytes()).isEqualTo(3141592653590L);
    }

    @Test
    public void testLegacyConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config_legacy.json");
        ResourceGroupId globalId = new ResourceGroupId("global");
        TestingResourceGroup global = new TestingResourceGroup(globalId);
        manager.configure((ResourceGroup)global, new SelectionContext(globalId, (Object)new ResourceGroupIdTemplate("global")));
        Assertions.assertThat((long)global.getSoftMemoryLimitBytes()).isEqualTo(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assertions.assertThat((int)global.getMaxQueuedQueries()).isEqualTo(99);
        Assertions.assertThat((int)global.getHardConcurrencyLimit()).isEqualTo(42);
    }

    private static void assertMatch(FileResourceGroupConfigurationManager manager, SelectionCriteria criteria, String expectedResourceGroup) {
        ResourceGroupId resourceGroupId = TestFileResourceGroupConfigurationManager.match(manager, criteria).getResourceGroupId();
        ((AbstractStringAssert)Assertions.assertThat((String)resourceGroupId.toString()).describedAs(String.format("Expected: '%s' resource group, found: %s", expectedResourceGroup, resourceGroupId), new Object[0])).isEqualTo(expectedResourceGroup);
    }

    private static SelectionContext<ResourceGroupIdTemplate> match(FileResourceGroupConfigurationManager manager, SelectionCriteria criteria) {
        return (SelectionContext)manager.match(criteria).orElseThrow(() -> new IllegalStateException("No match"));
    }

    private static void assertFails(String fileName, String expectedPattern) {
        Assertions.assertThatThrownBy(() -> TestFileResourceGroupConfigurationManager.parse(fileName)).hasMessageMatching(expectedPattern);
    }

    private static FileResourceGroupConfigurationManager parse(String fileName) {
        FileResourceGroupConfig config = new FileResourceGroupConfig();
        config.setConfigFile(Resources.getResource((String)fileName).getPath());
        return new FileResourceGroupConfigurationManager(listener -> listener.accept(new MemoryPoolInfo(31415926535900L, 0L, 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of())), config);
    }

    private static ManagerSpec parseManagerSpec(String fileName) {
        FileResourceGroupConfig config = new FileResourceGroupConfig();
        config.setConfigFile(Resources.getResource((String)fileName).getPath());
        return FileResourceGroupConfigurationManager.parseManagerSpec((FileResourceGroupConfig)config);
    }

    private static SelectionCriteria userAndSourceSelectionCriteria(String user, String source) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.of(), user, Optional.empty(), Optional.of(source), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }

    private static SelectionCriteria userSelectionCriteria(String user) {
        return TestFileResourceGroupConfigurationManager.userAndSourceSelectionCriteria(user, "source");
    }

    private static SelectionCriteria identitySelectionCriteria(String user, String originalUser, Optional<String> authenticatedUser) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.of(), originalUser, authenticatedUser, Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }

    private static SelectionCriteria queryTypeSelectionCriteria(String queryType) {
        return new SelectionCriteria(true, "test_user", (Set)ImmutableSet.of(), "test_user", Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.of(queryType));
    }

    private static SelectionCriteria userGroupsSelectionCriteria(String ... groups) {
        return new SelectionCriteria(true, "test_user", (Set)ImmutableSet.copyOf((Object[])groups), "test_user", Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }

    private static SelectionCriteria userAndUserGroupsSelectionCriteria(String user, String group, String ... groups) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.builder().add((Object)group).add((Object[])groups).build(), user, Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }
}

