/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.StaticSelector;
import io.trino.plugin.resourcegroups.VariableMap;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import io.trino.spi.session.ResourceEstimates;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestResourceGroupIdTemplate {
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());

    @Test
    public void testExpansion() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.${USER}.${SOURCE}");
        ResourceGroupId expected = new ResourceGroupId(new ResourceGroupId(new ResourceGroupId("test"), "u"), "s");
        Assertions.assertThat((Object)template.expandTemplate(new VariableMap((Map)ImmutableMap.of((Object)"USER", (Object)"u", (Object)"SOURCE", (Object)"s")))).isEqualTo((Object)expected);
        template = new ResourceGroupIdTemplate("test.${USER}");
        Assertions.assertThat((Object)template.expandTemplate(new VariableMap((Map)ImmutableMap.of((Object)"USER", (Object)"alice.smith", (Object)"SOURCE", (Object)"s")))).isEqualTo((Object)new ResourceGroupId(new ResourceGroupId("test"), "alice.smith"));
    }

    @Test
    public void testExtraction() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.job_${pipeline}_user:${USER}.${USER}");
        ResourceGroupId expected = new ResourceGroupId(new ResourceGroupId(new ResourceGroupId(new ResourceGroupId("test"), "pipeline"), "job_testpipeline_user:user"), "user");
        Pattern sourcePattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), "user", Optional.empty(), Optional.of("scheduler.important.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        Assertions.assertThat(selector.match(context).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(expected));
    }

    @Test
    public void testNoSource() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${SOURCE}_s");
        ResourceGroupId expected = new ResourceGroupId(new ResourceGroupId(new ResourceGroupId(new ResourceGroupId("test"), "pipeline"), "testpipeline"), "_s");
        Pattern userPattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
        StaticSelector selector = new StaticSelector(Optional.of(userPattern), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "scheduler.important.testpipeline[5]", (Set)ImmutableSet.of(), "user", Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        Assertions.assertThat(selector.match(context).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(expected));
    }

    @Test
    public void testNoMatch() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${USER}");
        Pattern sourcePattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), "user", Optional.empty(), Optional.of("scheduler.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        Assertions.assertThat((Optional)selector.match(context)).isEmpty();
    }

    @Test
    public void testUnresolvedVariableLoadTime() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${user}");
            Pattern sourcePattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
            StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), template);
            SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), "user", Optional.empty(), Optional.of("scheduler.important.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
            selector.match(context);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("unresolved variables \\[user\\] in resource group ID.*");
    }

    @Test
    public void testUnresolvedVariableRunTime() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${USER}");
            Pattern sourcePattern = Pattern.compile("scheduler.important.(testpipeline\\[|(?<pipeline>[^\\[]*)).*");
            StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), template);
            SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), "user", Optional.empty(), Optional.of("scheduler.important.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
            selector.match(context);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("unresolved variable 'pipeline' in resource group '\\$\\{pipeline\\}', available.*");
    }
}

