/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.SelectorResourceEstimate;
import io.trino.plugin.resourcegroups.StaticSelector;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import io.trino.spi.session.ResourceEstimates;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStaticSelector {
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());

    @Test
    public void testUserRegex() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.of(Pattern.compile("user.*")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat(selector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat(selector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteria("A.user", null, (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES))).isEqualTo(Optional.empty());
    }

    @Test
    public void testUserRegexCustomGroup() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo_userA_A");
        StaticSelector selector = new StaticSelector(Optional.of(Pattern.compile("user(?<suffix>.*)")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo_${USER}_${suffix}"));
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES))).hasValueSatisfying(context -> {
            Assertions.assertThat((Object)context.getResourceGroupId()).isEqualTo((Object)resourceGroupId);
            Assertions.assertThat((Collection)((ResourceGroupIdTemplate)context.getContext()).getVariableNames()).containsExactlyInAnyOrder((Object[])new String[]{"suffix", "USER"});
        });
    }

    @Test
    public void testOriginalUserRegex() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("originalUser.*")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat(selector.match(this.newSelectionCriteriaUsers("userA", "originalUserA", null)).map(SelectionContext::getResourceGroupId)).hasValue((Object)resourceGroupId);
        Assertions.assertThat(selector.match(this.newSelectionCriteriaUsers("userA", "originalUserB", null)).map(SelectionContext::getResourceGroupId)).hasValue((Object)resourceGroupId);
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteriaUsers("userA", "A.originalUser", null))).isEmpty();
    }

    @Test
    public void testOriginalUserRegexCustomGroup() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo_originalUserA_A");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("(?<original>originalUser(?<suffix>.*))")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo_${original}_${suffix}"));
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteriaUsers("userA", "originalUserA", null))).hasValueSatisfying(context -> {
            Assertions.assertThat((Object)context.getResourceGroupId()).isEqualTo((Object)resourceGroupId);
            Assertions.assertThat((Collection)((ResourceGroupIdTemplate)context.getContext()).getVariableNames()).containsExactlyInAnyOrder((Object[])new String[]{"suffix", "original"});
        });
    }

    @Test
    public void testAuthenticatedUserRegex() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("authenticatedUser.*")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat(selector.match(this.newSelectionCriteriaUsers("userA", "userA", "authenticatedUserA")).map(SelectionContext::getResourceGroupId)).hasValue((Object)resourceGroupId);
        Assertions.assertThat(selector.match(this.newSelectionCriteriaUsers("userA", "userA", "authenticatedUserB")).map(SelectionContext::getResourceGroupId)).hasValue((Object)resourceGroupId);
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteriaUsers("userA", "userA", "A.authenticatedUser"))).isEmpty();
    }

    @Test
    public void testAuthenticatedUserRegexCustomGroup() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo_authenticatedUser_A");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("(?<auth>authenticatedUser)(?<suffix>.*)")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo_${auth}_${suffix}"));
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteriaUsers("userA", "userA", "authenticatedUserA"))).hasValueSatisfying(context -> {
            Assertions.assertThat((Object)context.getResourceGroupId()).isEqualTo((Object)resourceGroupId);
            Assertions.assertThat((Collection)((ResourceGroupIdTemplate)context.getContext()).getVariableNames()).containsExactlyInAnyOrder((Object[])new String[]{"suffix", "auth"});
        });
    }

    @Test
    public void testSourceRegex() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile(".*source.*")), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES))).isEqualTo(Optional.empty());
        Assertions.assertThat(selector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat(selector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
    }

    @Test
    public void testSourceRegexEmptyMatch() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("$^")), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat(selector.match(this.newSelectionCriteria("user", null, (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat(selector.match(this.newSelectionCriteria("user", "", (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteria("user", "source", (Set<String>)ImmutableSet.of((Object)""), EMPTY_RESOURCE_ESTIMATES))).isEqualTo(Optional.empty());
    }

    @Test
    public void testClientTags() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(ImmutableList.of((Object)"tag1", (Object)"tag2")), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat(selector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)selector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES))).isEqualTo(Optional.empty());
        Assertions.assertThat(selector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2", (Object)"tag3"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
    }

    @Test
    public void testSelectorResourceEstimate() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector smallQuerySelector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new SelectorResourceEstimate(Optional.of(new SelectorResourceEstimate.Range(Optional.empty(), Optional.of(new Duration(5.0, TimeUnit.MINUTES)))), Optional.empty(), Optional.of(new SelectorResourceEstimate.Range(Optional.empty(), Optional.of(DataSize.valueOf((String)"500MB")))))), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat(smallQuerySelector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2"), new ResourceEstimates(Optional.of(java.time.Duration.ofMinutes(4L)), Optional.empty(), Optional.of(DataSize.of((long)400L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes())))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat(smallQuerySelector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), new ResourceEstimates(Optional.of(java.time.Duration.ofMinutes(4L)), Optional.empty(), Optional.of(DataSize.of((long)600L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes())))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.empty());
        Assertions.assertThat(smallQuerySelector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), new ResourceEstimates(Optional.of(java.time.Duration.ofMinutes(4L)), Optional.empty(), Optional.empty()))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.empty());
        StaticSelector largeQuerySelector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new SelectorResourceEstimate(Optional.empty(), Optional.empty(), Optional.of(new SelectorResourceEstimate.Range(Optional.of(DataSize.valueOf((String)"5TB")), Optional.empty())))), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assertions.assertThat(largeQuerySelector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2"), new ResourceEstimates(Optional.of(java.time.Duration.ofHours(100L)), Optional.empty(), Optional.of(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes())))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.empty());
        Assertions.assertThat(largeQuerySelector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.of(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes())))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
        Assertions.assertThat(largeQuerySelector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), new ResourceEstimates(Optional.of(java.time.Duration.ofSeconds(1L)), Optional.of(java.time.Duration.ofSeconds(1L)), Optional.of(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes())))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId));
    }

    private SelectionCriteria newSelectionCriteria(String user, String source, Set<String> tags, ResourceEstimates resourceEstimates) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.of(), user, Optional.empty(), Optional.ofNullable(source), tags, resourceEstimates, Optional.empty());
    }

    private SelectionCriteria newSelectionCriteriaUsers(String user, String originalUser, String authenticatedUser) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.of(), originalUser, Optional.ofNullable(authenticatedUser), Optional.empty(), Set.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }
}

