/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.FlywayMigration;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.Isolated;
import org.testcontainers.containers.JdbcDatabaseContainer;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
@Isolated
public abstract class BaseTestDbResourceGroupsFlywayMigration {
    protected final JdbcDatabaseContainer<?> container = this.startContainer();
    protected final Jdbi jdbi = Jdbi.create((String)this.container.getJdbcUrl(), (String)this.container.getUsername(), (String)this.container.getPassword());

    protected abstract JdbcDatabaseContainer<?> startContainer();

    protected abstract boolean tableExists(String var1);

    @AfterAll
    public final void close() {
        this.container.close();
    }

    @Test
    public void testMigrationWithEmptyDatabase() {
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl(this.container.getJdbcUrl()).setConfigDbUser(this.container.getUsername()).setConfigDbPassword(this.container.getPassword());
        FlywayMigration.migrate((DbResourceGroupConfig)config);
        this.verifyResourceGroupsSchema(0);
        this.dropAllTables();
    }

    @Test
    public void testMigrationWithNonEmptyDatabase() {
        String t1Create = "CREATE TABLE t1 (id INT)";
        String t2Create = "CREATE TABLE t2 (id INT)";
        Handle jdbiHandle = this.jdbi.open();
        jdbiHandle.execute(t1Create, new Object[0]);
        jdbiHandle.execute(t2Create, new Object[0]);
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl(this.container.getJdbcUrl()).setConfigDbUser(this.container.getUsername()).setConfigDbPassword(this.container.getPassword());
        FlywayMigration.migrate((DbResourceGroupConfig)config);
        this.verifyResourceGroupsSchema(0);
        String t1Drop = "DROP TABLE t1";
        String t2Drop = "DROP TABLE t2";
        jdbiHandle.execute(t1Drop, new Object[0]);
        jdbiHandle.execute(t2Drop, new Object[0]);
        jdbiHandle.close();
        this.dropAllTables();
    }

    @Test
    public void testMigrationDisabled() {
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl(this.container.getJdbcUrl()).setConfigDbUser(this.container.getUsername()).setConfigDbPassword(this.container.getPassword()).setRunMigrationsEnabled(false);
        FlywayMigration.migrate((DbResourceGroupConfig)config);
        Assertions.assertThat((boolean)this.tableExists("resource_groups")).isFalse();
        Assertions.assertThat((boolean)this.tableExists("resource_groups_global_properties")).isFalse();
    }

    protected void verifyResourceGroupsSchema(int expectedPropertiesCount) {
        this.verifyResultSetCount("SELECT name FROM resource_groups_global_properties", expectedPropertiesCount);
        this.verifyResultSetCount("SELECT name FROM resource_groups", 0);
        this.verifyResultSetCount("SELECT user_regex FROM selectors", 0);
        this.verifyResultSetCount("SELECT environment FROM exact_match_source_selectors", 0);
    }

    private void verifyResultSetCount(String sql, int expectedCount) {
        List results = (List)this.jdbi.withHandle(handle -> handle.createQuery(sql).mapTo(String.class).list());
        Assertions.assertThat((List)results).hasSize(expectedCount);
    }

    protected void dropAllTables() {
        String propertiesTable = "DROP TABLE IF EXISTS resource_groups_global_properties";
        String resourceGroupsTable = "DROP TABLE IF EXISTS resource_groups";
        String selectorsTable = "DROP TABLE IF EXISTS selectors";
        String exactMatchTable = "DROP TABLE IF EXISTS exact_match_source_selectors";
        String flywayHistoryTable = "DROP TABLE IF EXISTS flyway_schema_history";
        Handle jdbiHandle = this.jdbi.open();
        jdbiHandle.execute(propertiesTable, new Object[0]);
        jdbiHandle.execute(selectorsTable, new Object[0]);
        jdbiHandle.execute(resourceGroupsTable, new Object[0]);
        jdbiHandle.execute(exactMatchTable, new Object[0]);
        jdbiHandle.execute(flywayHistoryTable, new Object[0]);
        jdbiHandle.close();
    }
}

