/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import jakarta.validation.constraints.AssertTrue;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDbResourceGroupConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DbResourceGroupConfig)ConfigAssertions.recordDefaults(DbResourceGroupConfig.class)).setConfigDbUrl(null).setConfigDbUser(null).setConfigDbPassword(null).setMaxRefreshInterval(new Duration(1.0, TimeUnit.HOURS)).setRefreshInterval(new Duration(1.0, TimeUnit.SECONDS)).setExactMatchSelectorEnabled(false).setRunMigrationsEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"resource-groups.config-db-url", (Object)"jdbc:mysql://localhost:3306/config").put((Object)"resource-groups.config-db-user", (Object)"trino_admin").put((Object)"resource-groups.config-db-password", (Object)"trino_admin_pass").put((Object)"resource-groups.max-refresh-interval", (Object)"1m").put((Object)"resource-groups.refresh-interval", (Object)"2s").put((Object)"resource-groups.exact-match-selector-enabled", (Object)"true").put((Object)"resource-groups.db-migrations-enabled", (Object)"false").buildOrThrow();
        DbResourceGroupConfig expected = new DbResourceGroupConfig().setConfigDbUrl("jdbc:mysql://localhost:3306/config").setConfigDbUser("trino_admin").setConfigDbPassword("trino_admin_pass").setMaxRefreshInterval(new Duration(1.0, TimeUnit.MINUTES)).setRefreshInterval(new Duration(2.0, TimeUnit.SECONDS)).setExactMatchSelectorEnabled(true).setRunMigrationsEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        Assertions.assertThat((boolean)expected.isRefreshIntervalValid()).isTrue();
    }

    @Test
    public void testValidation() {
        ValidationAssertions.assertFailsValidation((Object)new DbResourceGroupConfig().setRefreshInterval(new Duration(2.0, TimeUnit.HOURS)), (String)"refreshIntervalValid", (String)"maxRefreshInterval must be greater than refreshInterval", AssertTrue.class);
    }
}

