/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.resourcegroups.InternalResourceGroup;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.ResourceGroupSelector;
import io.trino.plugin.resourcegroups.StaticSelector;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.trino.plugin.resourcegroups.db.DbSourceExactMatchSelector;
import io.trino.plugin.resourcegroups.db.H2DaoProvider;
import io.trino.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.trino.plugin.resourcegroups.db.ResourceGroupsDao;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroup;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import io.trino.spi.session.ResourceEstimates;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.h2.jdbc.JdbcException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDbResourceGroupConfigurationManager {
    private static final String ENVIRONMENT = "test";
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());

    static H2DaoProvider setup(String prefix) {
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl("jdbc:h2:mem:test_" + prefix + System.nanoTime() + ThreadLocalRandom.current().nextLong() + ";NON_KEYWORDS=KEY,VALUE");
        return new H2DaoProvider(config);
    }

    @Test
    public void testEnvironments() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_configuration");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        String prodEnvironment = "prod";
        String devEnvironment = "dev";
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        dao.insertResourceGroup(1L, "prod_global", "10MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, prodEnvironment);
        dao.insertResourceGroup(2L, "dev_global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, devEnvironment);
        dao.insertSelector(1L, 1L, ".*prod_user.*", null, null, null, null, null, null, null);
        dao.insertSelector(2L, 2L, ".*dev_user.*", null, null, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), prodEnvironment);
        List groups = manager.getRootGroups();
        Assertions.assertThat((List)groups).hasSize(1);
        InternalResourceGroup prodGlobal = new InternalResourceGroup("prod_global", (group, export) -> {}, MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)prodGlobal, new SelectionContext(prodGlobal.getId(), (Object)new ResourceGroupIdTemplate("prod_global")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(prodGlobal, "10MB", 1000, 100, 100, SchedulingPolicy.WEIGHTED, 1, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        Assertions.assertThat((List)manager.getSelectors()).hasSize(1);
        ResourceGroupSelector prodSelector = (ResourceGroupSelector)manager.getSelectors().get(0);
        ResourceGroupId prodResourceGroupId = ((SelectionContext)prodSelector.match(new SelectionCriteria(true, "prod_user", (Set)ImmutableSet.of(), "prod_user", Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty())).get()).getResourceGroupId();
        Assertions.assertThat((String)prodResourceGroupId.toString()).isEqualTo("prod_global");
        manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), devEnvironment);
        Assertions.assertThat((List)groups).hasSize(1);
        InternalResourceGroup devGlobal = new InternalResourceGroup("dev_global", (group, export) -> {}, MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)devGlobal, new SelectionContext(prodGlobal.getId(), (Object)new ResourceGroupIdTemplate("dev_global")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(devGlobal, "1MB", 1000, 100, 100, SchedulingPolicy.WEIGHTED, 1, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        Assertions.assertThat((List)manager.getSelectors()).hasSize(1);
        ResourceGroupSelector devSelector = (ResourceGroupSelector)manager.getSelectors().get(0);
        ResourceGroupId devResourceGroupId = ((SelectionContext)devSelector.match(new SelectionCriteria(true, "dev_user", (Set)ImmutableSet.of(), "dev_user", Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty())).get()).getResourceGroupId();
        Assertions.assertThat((String)devResourceGroupId.toString()).isEqualTo("dev_global");
    }

    @Test
    public void testConfiguration() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_configuration");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertSelector(2L, 1L, null, null, null, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        InternalResourceGroup global = new InternalResourceGroup("global", (group, export) -> {}, MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)global, new SelectionContext(global.getId(), (Object)new ResourceGroupIdTemplate("global")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(global, "1MB", 1000, 100, 100, SchedulingPolicy.WEIGHTED, 1, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        InternalResourceGroup sub = global.getOrCreateSubGroup("sub");
        manager.configure((ResourceGroup)sub, new SelectionContext(sub.getId(), (Object)new ResourceGroupIdTemplate("global.sub")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(sub, "2MB", 4, 3, 3, SchedulingPolicy.FAIR, 5, false, java.time.Duration.ofMillis(Long.MAX_VALUE), java.time.Duration.ofMillis(Long.MAX_VALUE));
    }

    @Test
    public void testDuplicateRoots() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_dup_roots");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        Assertions.assertThatThrownBy(() -> dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, null, null, null, null, null, null, ENVIRONMENT)).isInstanceOfSatisfying(UnableToExecuteStatementException.class, ex -> {
            Assertions.assertThat((Throwable)ex.getCause()).isInstanceOf(JdbcException.class);
            Assertions.assertThat((String)ex.getCause().getMessage()).startsWith((CharSequence)"Unique index or primary key violation");
        });
        dao.insertSelector(1L, 1L, null, null, null, null, null, null, null, null);
    }

    @Test
    public void testDuplicateGroups() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_dup_subs");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "1MB", 1000, 100, 100, null, null, null, null, null, 1L, ENVIRONMENT);
        Assertions.assertThatThrownBy(() -> dao.insertResourceGroup(2L, "sub", "1MB", 1000, 100, 100, null, null, null, null, null, 1L, ENVIRONMENT)).isInstanceOfSatisfying(UnableToExecuteStatementException.class, ex -> {
            Assertions.assertThat((Throwable)ex.getCause()).isInstanceOf(JdbcException.class);
            Assertions.assertThat((String)ex.getCause().getMessage()).startsWith((CharSequence)"Unique index or primary key violation");
        });
        dao.insertSelector(2L, 2L, null, null, null, null, null, null, null, null);
    }

    @Test
    public void testMissing() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_missing");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        dao.insertSelector(2L, 1L, null, null, null, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        InternalResourceGroup missing = new InternalResourceGroup("missing", (group, export) -> {}, MoreExecutors.directExecutor());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> manager.configure((ResourceGroup)missing, new SelectionContext(missing.getId(), (Object)new ResourceGroupIdTemplate("missing")))).isInstanceOf(IllegalStateException.class)).hasMessage("No matching configuration found for [missing] using [missing]");
    }

    @Test
    @Timeout(value=60L)
    public void testReconfig() throws Exception {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_reconfig");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertSelector(2L, 1L, null, null, null, null, null, null, null, null);
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.start();
        InternalResourceGroup global = new InternalResourceGroup("global", (group, export) -> {}, MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)global, new SelectionContext(global.getId(), (Object)new ResourceGroupIdTemplate("global")));
        InternalResourceGroup globalSub = global.getOrCreateSubGroup("sub");
        manager.configure((ResourceGroup)globalSub, new SelectionContext(globalSub.getId(), (Object)new ResourceGroupIdTemplate("global.sub")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(globalSub, "2MB", 4, 3, 3, SchedulingPolicy.FAIR, 5, false, java.time.Duration.ofMillis(Long.MAX_VALUE), java.time.Duration.ofMillis(Long.MAX_VALUE));
        dao.updateResourceGroup(2L, "sub", "3MB", 2, 1, 1, "weighted", 6, true, "1h", "1d", 1L, ENVIRONMENT);
        do {
            TimeUnit.MILLISECONDS.sleep(500L);
        } while (!globalSub.getJmxExport());
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(globalSub, "3MB", 2, 1, 1, SchedulingPolicy.WEIGHTED, 6, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        dao.deleteSelectors(2L);
        dao.deleteResourceGroup(2L);
        do {
            TimeUnit.MILLISECONDS.sleep(500L);
        } while (!globalSub.isDisabled());
    }

    @Test
    public void testExactMatchSelector() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_exact_match_selector");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.createExactMatchSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertSelector(2L, 1L, null, null, null, null, null, null, null, null);
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        DbResourceGroupConfig config = new DbResourceGroupConfig();
        config.setExactMatchSelectorEnabled(true);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, config, (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.load();
        Assertions.assertThat((List)manager.getSelectors()).hasSize(2);
        Assertions.assertThat((Object)((ResourceGroupSelector)manager.getSelectors().get(0))).isInstanceOf(DbSourceExactMatchSelector.class);
        config.setExactMatchSelectorEnabled(false);
        manager = new DbResourceGroupConfigurationManager(listener -> {}, config, (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.load();
        Assertions.assertThat((List)manager.getSelectors()).hasSize(1);
        Assertions.assertThat((boolean)(manager.getSelectors().get(0) instanceof DbSourceExactMatchSelector)).isFalse();
    }

    @Test
    public void testSelectorPriority() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        int numberOfUsers = 100;
        ArrayList<String> expectedUsers = new ArrayList<String>();
        int[] randomPriorities = ThreadLocalRandom.current().ints(0, 1000).distinct().limit(100L).toArray();
        for (int i = 0; i < 100; ++i) {
            int priority = randomPriorities[i];
            String user = String.valueOf(priority);
            dao.insertSelector(1L, priority, user, null, null, null, ".*", null, null, null);
            expectedUsers.add(user);
        }
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.load();
        List selectors = manager.getSelectors();
        Assertions.assertThat((List)selectors).hasSize(expectedUsers.size());
        expectedUsers.sort(Comparator.comparingInt(Integer::parseInt).reversed());
        for (int i = 0; i < 100; ++i) {
            Optional user = ((StaticSelector)selectors.get(i)).getUserRegex();
            Assertions.assertThat((Optional)user).isPresent();
            Assertions.assertThat((String)((Pattern)user.get()).pattern()).isEqualTo((String)expectedUsers.get(i));
        }
    }

    @Test
    public void testInvalidConfiguration() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(new Duration(2.0, TimeUnit.MILLISECONDS)).setRefreshInterval(new Duration(1.0, TimeUnit.MILLISECONDS)), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DbResourceGroupConfigurationManager)manager).getSelectors()).isInstanceOf(TrinoException.class)).hasMessage("No selectors are configured");
    }

    @Test
    public void testRefreshInterval() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(new Duration(2.0, TimeUnit.MILLISECONDS)).setRefreshInterval(new Duration(1.0, TimeUnit.MILLISECONDS)), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        dao.dropSelectorsTable();
        manager.load();
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ((DbResourceGroupConfigurationManager)manager).getSelectors()).hasMessage("Selectors cannot be fetched from database");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ((DbResourceGroupConfigurationManager)manager).getRootGroups()).hasMessage("Root groups cannot be fetched from database");
        manager.destroy();
    }

    @Test
    public void testMatchByUserGroups() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "group", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertSelector(1L, 1L, null, "first matching|second matching", null, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(new Duration(2.0, TimeUnit.MILLISECONDS)).setRefreshInterval(new Duration(1.0, TimeUnit.MILLISECONDS)), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.userGroupsSelectionCriteria("not matching"))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.userGroupsSelectionCriteria("first matching"))).map(SelectionContext::getContext).isEqualTo(Optional.of(new ResourceGroupIdTemplate("group")));
    }

    @Test
    public void testMatchByUsersAndGroups() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "group", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertSelector(1L, 1L, "Matching user", "Matching group", null, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(new Duration(2.0, TimeUnit.MILLISECONDS)).setRefreshInterval(new Duration(1.0, TimeUnit.MILLISECONDS)), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Matching user", "Not matching group", new String[0]))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Not matching user", "Matching group", new String[0]))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Matching user", "Matching group", new String[0]))).map(SelectionContext::getContext).isEqualTo(Optional.of(new ResourceGroupIdTemplate("group")));
    }

    @Test
    public void testMatchByOriginalUser() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "group", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertSelector(1L, 1L, null, null, "foo.+", null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(new Duration(2.0, TimeUnit.MILLISECONDS)).setRefreshInterval(new Duration(1.0, TimeUnit.MILLISECONDS)), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "other-usr", Optional.empty()))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "other-usr", Optional.of("foo-usr")))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.identitySelectionCriteria("other-usr", "foo-usr", Optional.empty()))).map(SelectionContext::getContext).isEqualTo(Optional.of(new ResourceGroupIdTemplate("group")));
    }

    @Test
    public void testMatchByAuthenticatedUser() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "group", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertSelector(1L, 1L, null, null, null, "foo.+", null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(listener -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(new Duration(2.0, TimeUnit.MILLISECONDS)).setRefreshInterval(new Duration(1.0, TimeUnit.MILLISECONDS)), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "foo-usr", Optional.empty()))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.identitySelectionCriteria("foo-usr", "foo-usr", Optional.of("other-usr")))).isEmpty();
        Assertions.assertThat((Optional)manager.match(TestDbResourceGroupConfigurationManager.identitySelectionCriteria("other-usr", "other-usr", Optional.of("foo-usr")))).map(SelectionContext::getContext).isEqualTo(Optional.of(new ResourceGroupIdTemplate("group")));
    }

    @RepeatedTest(value=10)
    public void testConfigurationUpdateIsNotLost() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_lost_update");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "80%", 10, null, 1, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertSelector(1L, 1L, null, "userGroup", null, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager(consumer -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        Optional userGroup = manager.match(TestDbResourceGroupConfigurationManager.userGroupsSelectionCriteria("userGroup"));
        Assertions.assertThat((boolean)userGroup.isPresent()).isTrue();
        SelectionContext selectionContext = (SelectionContext)userGroup.get();
        InternalResourceGroup resourceGroup = new InternalResourceGroup("global", (internalResourceGroup, bl) -> {}, MoreExecutors.directExecutor());
        try (ExecutorService executor = Executors.newFixedThreadPool(2);){
            dao.updateResourceGroup(1L, "global", "80%", 10, null, 10, null, null, null, null, null, null, ENVIRONMENT);
            executor.submit(() -> {
                InternalResourceGroup internalResourceGroup = resourceGroup;
                synchronized (internalResourceGroup) {
                    Thread.sleep(10L);
                }
                return null;
            });
            executor.submit(() -> ((DbResourceGroupConfigurationManager)manager).load());
            manager.configure((ResourceGroup)resourceGroup, selectionContext);
            Assert.assertEventually(() -> {
                manager.load();
                Assertions.assertThat((int)resourceGroup.getHardConcurrencyLimit()).isEqualTo(10);
            });
        }
    }

    private static void assertEqualsResourceGroup(InternalResourceGroup group, String softMemoryLimit, int maxQueued, int hardConcurrencyLimit, int softConcurrencyLimit, SchedulingPolicy schedulingPolicy, int schedulingWeight, boolean jmxExport, java.time.Duration softCpuLimit, java.time.Duration hardCpuLimit) {
        Assertions.assertThat((long)group.getSoftMemoryLimitBytes()).isEqualTo(DataSize.valueOf((String)softMemoryLimit).toBytes());
        Assertions.assertThat((int)group.getMaxQueuedQueries()).isEqualTo(maxQueued);
        Assertions.assertThat((int)group.getHardConcurrencyLimit()).isEqualTo(hardConcurrencyLimit);
        Assertions.assertThat((int)group.getSoftConcurrencyLimit()).isEqualTo(softConcurrencyLimit);
        Assertions.assertThat((Comparable)group.getSchedulingPolicy()).isEqualTo((Object)schedulingPolicy);
        Assertions.assertThat((int)group.getSchedulingWeight()).isEqualTo(schedulingWeight);
        Assertions.assertThat((boolean)group.getJmxExport()).isEqualTo(jmxExport);
        Assertions.assertThat((java.time.Duration)group.getSoftCpuLimit()).isEqualTo((Object)softCpuLimit);
        Assertions.assertThat((java.time.Duration)group.getHardCpuLimit()).isEqualTo((Object)hardCpuLimit);
    }

    private static SelectionCriteria userGroupsSelectionCriteria(String ... groups) {
        return new SelectionCriteria(true, "test_user", (Set)ImmutableSet.copyOf((Object[])groups), "test_user", Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }

    private static SelectionCriteria userAndUserGroupsSelectionCriteria(String user, String group, String ... groups) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.builder().add((Object)group).add((Object[])groups).build(), user, Optional.empty(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }

    private static SelectionCriteria identitySelectionCriteria(String user, String originalUser, Optional<String> authenticatedUser) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.of(), originalUser, authenticatedUser, Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }
}

