/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import io.trino.plugin.resourcegroups.db.BaseTestDbResourceGroupsFlywayMigration;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.FlywayMigration;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;

public class TestDbResourceGroupsMysqlFlywayMigration
extends BaseTestDbResourceGroupsFlywayMigration {
    @Override
    protected final JdbcDatabaseContainer<?> startContainer() {
        MySQLContainer container = new MySQLContainer("mysql:8.0.36");
        container.start();
        return container;
    }

    @Override
    protected final boolean tableExists(String tableName) {
        return (Long)this.jdbi.withHandle(handle -> (Long)((Query)handle.createQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_name = :tableName").bind("tableName", tableName)).mapTo(Long.class).one()) > 0L;
    }

    @Test
    public void testMigrationWithOldResourceGroupsSchema() {
        this.createOldSchema();
        this.jdbi.withHandle(handle -> handle.execute("INSERT INTO resource_groups_global_properties VALUES ('a_name', 'a_value')", new Object[0]));
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl(this.container.getJdbcUrl()).setConfigDbUser(this.container.getUsername()).setConfigDbPassword(this.container.getPassword());
        FlywayMigration.migrate((DbResourceGroupConfig)config);
        this.verifyResourceGroupsSchema(1);
        this.dropAllTables();
    }

    private void createOldSchema() {
        String propertiesTable = "CREATE TABLE resource_groups_global_properties (\n    name VARCHAR(128) NOT NULL PRIMARY KEY,\n    value VARCHAR(512) NULL,\n    CHECK (name in ('cpu_quota_period', 'a_name', 'a_value'))\n);";
        String resourceGroupsTable = "CREATE TABLE resource_groups (\n    resource_group_id BIGINT NOT NULL AUTO_INCREMENT,\n    name VARCHAR(250) NOT NULL,\n    soft_memory_limit VARCHAR(128) NOT NULL,\n    max_queued INT NOT NULL,\n    soft_concurrency_limit INT NULL,\n    hard_concurrency_limit INT NOT NULL,\n    scheduling_policy VARCHAR(128) NULL,\n    scheduling_weight INT NULL,\n    jmx_export BOOLEAN NULL,\n    soft_cpu_limit VARCHAR(128) NULL,\n    hard_cpu_limit VARCHAR(128) NULL,\n    parent BIGINT NULL,\n    environment VARCHAR(128) NULL,\n    PRIMARY KEY (resource_group_id),\n    FOREIGN KEY (parent) REFERENCES resource_groups (resource_group_id) ON DELETE CASCADE\n);";
        String selectorsTable = "CREATE TABLE selectors (\n     resource_group_id BIGINT NOT NULL,\n     priority BIGINT NOT NULL,\n     user_regex VARCHAR(512),\n     source_regex VARCHAR(512),\n     query_type VARCHAR(512),\n     client_tags VARCHAR(512),\n     selector_resource_estimate VARCHAR(1024),\n     FOREIGN KEY (resource_group_id) REFERENCES resource_groups (resource_group_id) ON DELETE CASCADE\n);";
        Handle jdbiHandle = this.jdbi.open();
        jdbiHandle.execute(propertiesTable, new Object[0]);
        jdbiHandle.execute(resourceGroupsTable, new Object[0]);
        jdbiHandle.execute(selectorsTable, new Object[0]);
        jdbiHandle.close();
    }
}

