/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import io.trino.plugin.resourcegroups.db.BaseTestDbResourceGroupsFlywayMigration;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;

public class TestDbResourceGroupsOracleFlywayMigration
extends BaseTestDbResourceGroupsFlywayMigration {
    @Override
    protected final JdbcDatabaseContainer<?> startContainer() {
        JdbcDatabaseContainer container = (JdbcDatabaseContainer)new OracleContainer("gvenzl/oracle-xe:18.4.0-slim").withPassword("trino").withEnv("ORACLE_PASSWORD", "trino");
        container.start();
        return container;
    }

    @Override
    protected final boolean tableExists(String tableName) {
        return (Long)this.jdbi.withHandle(handle -> (Long)((Query)handle.createQuery("SELECT COUNT(*) FROM user_tables WHERE table_name = :tableName").bind("tableName", tableName)).mapTo(Long.class).one()) > 0L;
    }

    @Override
    protected void dropAllTables() {
        String propertiesTable = "resource_groups_global_properties".toUpperCase(Locale.ENGLISH);
        String resourceGroupsTable = "resource_groups".toUpperCase(Locale.ENGLISH);
        String selectorsTable = "selectors".toUpperCase(Locale.ENGLISH);
        String exactMatchTable = "exact_match_source_selectors".toUpperCase(Locale.ENGLISH);
        String flywayHistoryTable = "flyway_schema_history";
        Handle jdbiHandle = this.jdbi.open();
        if (this.tableExists(jdbiHandle, propertiesTable)) {
            jdbiHandle.execute("DROP TABLE " + propertiesTable, new Object[0]);
        }
        if (this.tableExists(jdbiHandle, selectorsTable)) {
            jdbiHandle.execute("DROP TABLE " + selectorsTable, new Object[0]);
        }
        if (this.tableExists(jdbiHandle, resourceGroupsTable)) {
            jdbiHandle.execute("DROP TABLE " + resourceGroupsTable, new Object[0]);
        }
        if (this.tableExists(jdbiHandle, exactMatchTable)) {
            jdbiHandle.execute("DROP TABLE " + exactMatchTable, new Object[0]);
        }
        if (this.tableExists(jdbiHandle, flywayHistoryTable)) {
            jdbiHandle.execute("DROP TABLE \"" + flywayHistoryTable + "\"", new Object[0]);
        }
        jdbiHandle.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableExists(Handle jdbiHandle, String tableName) {
        try {
            DatabaseMetaData metaData = jdbiHandle.getConnection().getMetaData();
            try (ResultSet resultSet = metaData.getTables(null, null, tableName, null);){
                String table;
                do {
                    if (!resultSet.next()) return false;
                } while (!tableName.equalsIgnoreCase(table = resultSet.getString("TABLE_NAME")));
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            return false;
        }
    }
}

