/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.DbSourceExactMatchSelector;
import io.trino.plugin.resourcegroups.db.H2DaoProvider;
import io.trino.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.trino.plugin.resourcegroups.db.ResourceGroupsDao;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import io.trino.spi.session.ResourceEstimates;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDbSourceExactMatchSelector {
    private static final JsonCodec<ResourceGroupId> CODEC = JsonCodec.jsonCodec(ResourceGroupId.class);
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());
    private final H2ResourceGroupsDao dao;

    public TestDbSourceExactMatchSelector() {
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl("jdbc:h2:mem:test_db-exact-match-selector" + System.nanoTime() + ThreadLocalRandom.current().nextLong());
        this.dao = new H2DaoProvider(config).get();
        this.dao.createExactMatchSelectorsTable();
    }

    @Test
    public void testMatch() {
        ResourceGroupId resourceGroupId1 = new ResourceGroupId((List)ImmutableList.of((Object)"global", (Object)"test", (Object)"user", (Object)"insert"));
        ResourceGroupId resourceGroupId2 = new ResourceGroupId((List)ImmutableList.of((Object)"global", (Object)"test", (Object)"user", (Object)"select"));
        this.dao.insertExactMatchSelector("test", "@test@test_pipeline", QueryType.INSERT.name(), CODEC.toJson((Object)resourceGroupId1));
        this.dao.insertExactMatchSelector("test", "@test@test_pipeline", QueryType.SELECT.name(), CODEC.toJson((Object)resourceGroupId2));
        DbSourceExactMatchSelector selector = new DbSourceExactMatchSelector("test", (ResourceGroupsDao)this.dao);
        Assertions.assertThat((Optional)selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), "testuser", Optional.empty(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.empty()))).isEqualTo(Optional.empty());
        Assertions.assertThat(selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), "testuser", Optional.empty(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.INSERT.name()))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId1));
        Assertions.assertThat(selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), "testuser", Optional.empty(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.SELECT.name()))).map(SelectionContext::getResourceGroupId)).isEqualTo(Optional.of(resourceGroupId2));
        Assertions.assertThat((Optional)selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), "testuser", Optional.empty(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.DELETE.name())))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), "testuser", Optional.empty(), Optional.of("@test@test_new"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.INSERT.name())))).isEqualTo(Optional.empty());
    }
}

