/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.resourcegroups.ResourceGroupNameTemplate;
import io.trino.plugin.resourcegroups.SelectorResourceEstimate;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.H2DaoProvider;
import io.trino.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.trino.plugin.resourcegroups.db.ResourceGroupGlobalProperties;
import io.trino.plugin.resourcegroups.db.ResourceGroupSpecBuilder;
import io.trino.plugin.resourcegroups.db.SelectorRecord;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.h2.jdbc.JdbcException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.junit.jupiter.api.Test;

public class TestResourceGroupsDao {
    private static final String ENVIRONMENT = "test";
    private static final SelectorResourceEstimate SELECTOR_RESOURCE_ESTIMATE = new SelectorResourceEstimate(Optional.of(new SelectorResourceEstimate.Range(Optional.empty(), Optional.of(new Duration(5.0, TimeUnit.MINUTES)))), Optional.of(new SelectorResourceEstimate.Range(Optional.of(new Duration(10.0, TimeUnit.SECONDS)), Optional.empty())), Optional.of(new SelectorResourceEstimate.Range(Optional.empty(), Optional.of(DataSize.valueOf((String)"500MB")))));
    private static final JsonCodec<List<String>> LIST_STRING_CODEC = JsonCodec.listJsonCodec(String.class);
    private static final JsonCodec<SelectorResourceEstimate> SELECTOR_RESOURCE_ESTIMATE_JSON_CODEC = JsonCodec.jsonCodec(SelectorResourceEstimate.class);

    static H2ResourceGroupsDao setup(String prefix) {
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl("jdbc:h2:mem:test_" + prefix + System.nanoTime() + ThreadLocalRandom.current().nextLong() + ";NON_KEYWORDS=KEY,VALUE");
        return new H2DaoProvider(config).get();
    }

    @Test
    public void testResourceGroups() {
        H2ResourceGroupsDao dao = TestResourceGroupsDao.setup("resource_groups");
        dao.createResourceGroupsTable();
        HashMap<Long, ResourceGroupSpecBuilder> map = new HashMap<Long, ResourceGroupSpecBuilder>();
        TestResourceGroupsDao.testResourceGroupInsert(dao, map);
        TestResourceGroupsDao.testResourceGroupUpdate(dao, map);
        TestResourceGroupsDao.testResourceGroupDelete(dao, map);
    }

    private static void testResourceGroupInsert(H2ResourceGroupsDao dao, Map<Long, ResourceGroupSpecBuilder> map) {
        dao.insertResourceGroup(1L, "global", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "bi", "50%", 50, 50, 50, null, null, null, null, null, 1L, ENVIRONMENT);
        List records = dao.getResourceGroups(ENVIRONMENT);
        Assertions.assertThat((List)records).hasSize(2);
        map.put(1L, new ResourceGroupSpecBuilder(1L, new ResourceGroupNameTemplate("global"), Optional.of("100%"), 100, Optional.of(100), 100, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        map.put(2L, new ResourceGroupSpecBuilder(2L, new ResourceGroupNameTemplate("bi"), Optional.of("50%"), 50, Optional.of(50), 50, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(1L)));
        TestResourceGroupsDao.compareResourceGroups(map, records);
    }

    private static void testResourceGroupUpdate(H2ResourceGroupsDao dao, Map<Long, ResourceGroupSpecBuilder> map) {
        dao.updateResourceGroup(2L, "bi", null, 40, 30, 30, null, null, true, null, null, 1L, ENVIRONMENT);
        ResourceGroupSpecBuilder updated = new ResourceGroupSpecBuilder(2L, new ResourceGroupNameTemplate("bi"), Optional.empty(), 40, Optional.of(30), 30, Optional.empty(), Optional.empty(), Optional.of(true), Optional.empty(), Optional.empty(), Optional.of(1L));
        map.put(2L, updated);
        TestResourceGroupsDao.compareResourceGroups(map, dao.getResourceGroups(ENVIRONMENT));
    }

    private static void testResourceGroupDelete(H2ResourceGroupsDao dao, Map<Long, ResourceGroupSpecBuilder> map) {
        dao.deleteResourceGroup(2L);
        map.remove(2L);
        TestResourceGroupsDao.compareResourceGroups(map, dao.getResourceGroups(ENVIRONMENT));
    }

    @Test
    public void testSelectors() {
        H2ResourceGroupsDao dao = TestResourceGroupsDao.setup("selectors");
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        HashMap<Long, SelectorRecord> map = new HashMap<Long, SelectorRecord>();
        TestResourceGroupsDao.testSelectorInsert(dao, map);
        TestResourceGroupsDao.testSelectorUpdate(dao, map);
        TestResourceGroupsDao.testSelectorUpdateNull(dao, map);
        TestResourceGroupsDao.testSelectorDelete(dao, map);
        TestResourceGroupsDao.testSelectorDeleteNull(dao, map);
        TestResourceGroupsDao.testSelectorMultiDelete(dao, map);
    }

    private static void testSelectorInsert(H2ResourceGroupsDao dao, Map<Long, SelectorRecord> map) {
        map.put(2L, new SelectorRecord(2L, 1L, Optional.of(Pattern.compile("ping_user")), Optional.of(Pattern.compile("ping_group")), Optional.of(Pattern.compile("ping_original_user")), Optional.of(Pattern.compile("ping_auth_user")), Optional.of(Pattern.compile(".*")), Optional.empty(), Optional.empty(), Optional.empty()));
        map.put(3L, new SelectorRecord(3L, 2L, Optional.of(Pattern.compile("admin_user")), Optional.of(Pattern.compile("admin_group")), Optional.of(Pattern.compile("admin_original_user")), Optional.of(Pattern.compile("admin_auth_user")), Optional.of(Pattern.compile(".*")), Optional.of(QueryType.EXPLAIN.name()), Optional.of(ImmutableList.of((Object)"tag1", (Object)"tag2")), Optional.empty()));
        map.put(4L, new SelectorRecord(4L, 0L, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(SELECTOR_RESOURCE_ESTIMATE)));
        dao.insertResourceGroup(1L, "admin", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "ping_query", "50%", 50, 50, 50, null, null, null, null, null, 1L, ENVIRONMENT);
        dao.insertResourceGroup(3L, "config", "50%", 50, 50, 50, null, null, null, null, null, 1L, ENVIRONMENT);
        dao.insertResourceGroup(4L, "config", "50%", 50, 50, 50, null, null, null, null, null, 1L, ENVIRONMENT);
        dao.insertSelector(2L, 1L, "ping_user", "ping_group", "ping_original_user", "ping_auth_user", ".*", null, null, null);
        dao.insertSelector(3L, 2L, "admin_user", "admin_group", "admin_original_user", "admin_auth_user", ".*", QueryType.EXPLAIN.name(), LIST_STRING_CODEC.toJson((Object)ImmutableList.of((Object)"tag1", (Object)"tag2")), null);
        dao.insertSelector(4L, 0L, null, null, null, null, null, null, null, SELECTOR_RESOURCE_ESTIMATE_JSON_CODEC.toJson((Object)SELECTOR_RESOURCE_ESTIMATE));
        List records = dao.getSelectors(ENVIRONMENT);
        TestResourceGroupsDao.compareSelectors(map, records);
    }

    private static void testSelectorUpdate(H2ResourceGroupsDao dao, Map<Long, SelectorRecord> map) {
        dao.updateSelector(2L, "ping.*", "ping_gr.*", "ping_original.*", "ping_auth.*", "ping_source", LIST_STRING_CODEC.toJson((Object)ImmutableList.of((Object)"tag1")), "ping_user", "ping_group", "ping_original_user", "ping_auth_user", ".*", null);
        SelectorRecord updated = new SelectorRecord(2L, 1L, Optional.of(Pattern.compile("ping.*")), Optional.of(Pattern.compile("ping_gr.*")), Optional.of(Pattern.compile("ping_original.*")), Optional.of(Pattern.compile("ping_auth.*")), Optional.of(Pattern.compile("ping_source")), Optional.empty(), Optional.of(ImmutableList.of((Object)"tag1")), Optional.empty());
        map.put(2L, updated);
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
    }

    private static void testSelectorUpdateNull(H2ResourceGroupsDao dao, Map<Long, SelectorRecord> map) {
        SelectorRecord updated = new SelectorRecord(2L, 3L, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        map.put(2L, updated);
        dao.updateSelector(2L, null, null, null, null, null, null, "ping.*", "ping_gr.*", "ping_original.*", "ping_auth.*", "ping_source", LIST_STRING_CODEC.toJson((Object)ImmutableList.of((Object)"tag1")));
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
        updated = new SelectorRecord(2L, 2L, Optional.of(Pattern.compile("ping.*")), Optional.of(Pattern.compile("ping_gr.*")), Optional.of(Pattern.compile("ping_original.*")), Optional.of(Pattern.compile("ping_auth.*")), Optional.of(Pattern.compile("ping_source")), Optional.of(QueryType.EXPLAIN.name()), Optional.of(ImmutableList.of((Object)"tag1", (Object)"tag2")), Optional.empty());
        map.put(2L, updated);
        dao.updateSelector(2L, "ping.*", "ping_gr.*", "ping_original.*", "ping_auth.*", "ping_source", LIST_STRING_CODEC.toJson((Object)ImmutableList.of((Object)"tag1", (Object)"tag2")), null, null, null, null, null, null);
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
    }

    private static void testSelectorDelete(H2ResourceGroupsDao dao, Map<Long, SelectorRecord> map) {
        map.remove(2L);
        dao.deleteSelector(2L, "ping.*", "ping_gr.*", "ping_original.*", "ping_auth.*", "ping_source", LIST_STRING_CODEC.toJson((Object)ImmutableList.of((Object)"tag1", (Object)"tag2")));
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
    }

    private static void testSelectorDeleteNull(H2ResourceGroupsDao dao, Map<Long, SelectorRecord> map) {
        dao.updateSelector(3L, null, null, null, null, null, null, "admin_user", "admin_group", "admin_original_user", "admin_auth_user", ".*", LIST_STRING_CODEC.toJson((Object)ImmutableList.of((Object)"tag1", (Object)"tag2")));
        SelectorRecord nullRegexes = new SelectorRecord(3L, 2L, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        map.put(3L, nullRegexes);
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
        dao.deleteSelector(3L, null, null, null, null, null, null);
        map.remove(3L);
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
    }

    private static void testSelectorMultiDelete(H2ResourceGroupsDao dao, Map<Long, SelectorRecord> map) {
        if (dao != null) {
            return;
        }
        dao.insertSelector(3L, 3L, "user1", null, null, null, "pipeline", null, null, null);
        map.put(3L, new SelectorRecord(3L, 3L, Optional.of(Pattern.compile("user1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("pipeline")), Optional.empty(), Optional.empty(), Optional.empty()));
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
        dao.deleteSelectors(3L);
        map.remove(3L);
        TestResourceGroupsDao.compareSelectors(map, dao.getSelectors(ENVIRONMENT));
    }

    @Test
    public void testGlobalResourceGroupProperties() {
        H2ResourceGroupsDao dao = TestResourceGroupsDao.setup("global_properties");
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        ResourceGroupGlobalProperties globalProperties = new ResourceGroupGlobalProperties(Optional.of(new Duration(1.0, TimeUnit.HOURS)));
        ResourceGroupGlobalProperties records = (ResourceGroupGlobalProperties)dao.getResourceGroupGlobalProperties().get(0);
        Assertions.assertThat((Object)globalProperties).isEqualTo((Object)records);
        try {
            dao.insertResourceGroupsGlobalProperties("invalid_property", "1h");
        }
        catch (UnableToExecuteStatementException ex) {
            Assertions.assertThat((Throwable)ex.getCause()).isInstanceOf(JdbcException.class);
            Assertions.assertThat((String)ex.getCause().getMessage()).startsWith((CharSequence)"Check constraint violation:");
        }
        try {
            dao.updateResourceGroupsGlobalProperties("invalid_property_name");
        }
        catch (UnableToExecuteStatementException ex) {
            Assertions.assertThat((Throwable)ex.getCause()).isInstanceOf(JdbcException.class);
            Assertions.assertThat((String)ex.getCause().getMessage()).startsWith((CharSequence)"Check constraint violation:");
        }
    }

    @Test
    public void testExactMatchSelector() {
        H2ResourceGroupsDao dao = TestResourceGroupsDao.setup("exact_match_selector");
        dao.createExactMatchSelectorsTable();
        ResourceGroupId resourceGroupId1 = new ResourceGroupId((List)ImmutableList.of((Object)"global", (Object)ENVIRONMENT, (Object)"user", (Object)"insert"));
        ResourceGroupId resourceGroupId2 = new ResourceGroupId((List)ImmutableList.of((Object)"global", (Object)ENVIRONMENT, (Object)"user", (Object)"select"));
        JsonCodec codec = JsonCodec.jsonCodec(ResourceGroupId.class);
        dao.insertExactMatchSelector(ENVIRONMENT, "@test@test_pipeline", QueryType.INSERT.name(), codec.toJson((Object)resourceGroupId1));
        dao.insertExactMatchSelector(ENVIRONMENT, "@test@test_pipeline", QueryType.SELECT.name(), codec.toJson((Object)resourceGroupId2));
        Assertions.assertThat((String)dao.getExactMatchResourceGroup(ENVIRONMENT, "@test@test_pipeline", null)).isNull();
        Assertions.assertThat((String)dao.getExactMatchResourceGroup(ENVIRONMENT, "@test@test_pipeline", QueryType.INSERT.name())).isEqualTo(codec.toJson((Object)resourceGroupId1));
        Assertions.assertThat((String)dao.getExactMatchResourceGroup(ENVIRONMENT, "@test@test_pipeline", QueryType.SELECT.name())).isEqualTo(codec.toJson((Object)resourceGroupId2));
        Assertions.assertThat((String)dao.getExactMatchResourceGroup(ENVIRONMENT, "@test@test_pipeline", QueryType.DELETE.name())).isNull();
        Assertions.assertThat((String)dao.getExactMatchResourceGroup(ENVIRONMENT, "abc", QueryType.INSERT.name())).isNull();
        Assertions.assertThat((String)dao.getExactMatchResourceGroup("prod", "@test@test_pipeline", QueryType.INSERT.name())).isNull();
    }

    private static void compareResourceGroups(Map<Long, ResourceGroupSpecBuilder> map, List<ResourceGroupSpecBuilder> records) {
        Assertions.assertThat(map).hasSize(records.size());
        for (ResourceGroupSpecBuilder record : records) {
            ResourceGroupSpecBuilder expected = map.get(record.getId());
            Assertions.assertThat((Object)record.build()).isEqualTo((Object)expected.build());
        }
    }

    private static void compareSelectors(Map<Long, SelectorRecord> map, List<SelectorRecord> records) {
        Assertions.assertThat(map).hasSize(records.size());
        for (SelectorRecord record : records) {
            SelectorRecord expected = map.get(record.getResourceGroupId());
            Assertions.assertThat((long)record.getResourceGroupId()).isEqualTo(expected.getResourceGroupId());
            Assertions.assertThat(record.getUserRegex().map(Pattern::pattern)).isEqualTo(expected.getUserRegex().map(Pattern::pattern));
            Assertions.assertThat(record.getUserGroupRegex().map(Pattern::pattern)).isEqualTo(expected.getUserGroupRegex().map(Pattern::pattern));
            Assertions.assertThat(record.getSourceRegex().map(Pattern::pattern)).isEqualTo(expected.getSourceRegex().map(Pattern::pattern));
            Assertions.assertThat(record.getOriginalUserRegex().map(Pattern::pattern)).isEqualTo(expected.getOriginalUserRegex().map(Pattern::pattern));
            Assertions.assertThat(record.getAuthenticatedUserRegex().map(Pattern::pattern)).isEqualTo(expected.getAuthenticatedUserRegex().map(Pattern::pattern));
            Assertions.assertThat((Optional)record.getSelectorResourceEstimate()).isEqualTo((Object)expected.getSelectorResourceEstimate());
        }
    }
}

