/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPMessage;
import com.nimbusds.oauth2.sdk.http.HTTPRequestSender;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPRequest;
import com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class HTTPRequest
extends HTTPMessage
implements ReadOnlyHTTPRequest {
    private final Method method;
    private URL url;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private Proxy proxy = null;
    private boolean followRedirects = true;
    private X509Certificate clientX509Certificate = null;
    private String clientX509CertificateSubjectDN = null;
    private String clientX509CertificateRootDN = null;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    private static HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    private static SSLSocketFactory defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private boolean debugCloseStreams = false;

    public HTTPRequest(Method method, URL url) {
        if (method == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.method = method;
        if (url == null) {
            throw new IllegalArgumentException("The HTTP URL must not be null");
        }
        this.url = url;
    }

    public HTTPRequest(Method method, URI uri) {
        this(method, HTTPRequest.toURLWithUncheckedException(uri));
    }

    private static URL toURLWithUncheckedException(URI uri) {
        try {
            return uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void ensureMethod(Method expectedMethod) throws ParseException {
        if (this.method != expectedMethod) {
            throw new ParseException("The HTTP request method must be " + String.valueOf((Object)expectedMethod));
        }
    }

    public String getAuthorization() {
        return this.getHeaderValue("Authorization");
    }

    public void setAuthorization(String authz) {
        this.setHeader("Authorization", new String[]{authz});
    }

    public SignedJWT getDPoP() {
        try {
            return this.getPoPWithException();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public SignedJWT getPoPWithException() throws ParseException {
        String dPoP = this.getHeaderValue("DPoP");
        if (dPoP == null) {
            return null;
        }
        try {
            return SignedJWT.parse((String)dPoP);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public void setDPoP(SignedJWT dPoPJWT) {
        if (dPoPJWT != null) {
            this.setHeader("DPoP", new String[]{dPoPJWT.serialize()});
        } else {
            this.setHeader("DPoP", null);
        }
    }

    public String getAccept() {
        return this.getHeaderValue("Accept");
    }

    public void setAccept(String accept) {
        this.setHeader("Accept", new String[]{accept});
    }

    void setDebugCloseStreams(boolean debugCloseStreams) {
        this.debugCloseStreams = debugCloseStreams;
    }

    public void appendQueryParameters(Map<String, List<String>> queryParams) {
        if (MapUtils.isEmpty(queryParams)) {
            return;
        }
        this.appendQueryString(URLUtils.serializeParameters(queryParams));
    }

    public void appendQueryString(String queryString) {
        if (StringUtils.isBlank(queryString)) {
            return;
        }
        if (StringUtils.isNotBlank(queryString) && queryString.startsWith("?")) {
            throw new IllegalArgumentException("The query string must not start with ?");
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(this.url.getQuery())) {
            sb.append(this.url.getQuery());
            sb.append('&');
        }
        sb.append(queryString);
        this.url = URLUtils.setEncodedQuery(this.url, sb.toString());
    }

    @Deprecated
    public String getQuery() {
        return Method.POST.equals((Object)this.getMethod()) ? this.getBody() : this.getURL().getQuery();
    }

    @Deprecated
    public void setQuery(String query) {
        if (Method.POST.equals((Object)this.getMethod())) {
            this.setBody(query);
        } else {
            this.appendQueryString(query);
        }
    }

    private void ensureQuery() throws ParseException {
        if (this.getQuery() == null || this.getQuery().trim().isEmpty()) {
            throw new ParseException("Missing or empty HTTP query string / entity body");
        }
    }

    public Map<String, List<String>> getQueryStringParameters() {
        return URLUtils.parseParameters(this.url.getQuery());
    }

    @Deprecated
    public Map<String, List<String>> getQueryParameters() {
        return URLUtils.parseParameters(this.getQuery());
    }

    @Deprecated
    public JSONObject getQueryAsJSONObject() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JSON);
        this.ensureQuery();
        return JSONObjectUtils.parse(this.getQuery());
    }

    @Deprecated
    public String getFragment() {
        return this.url.getRef();
    }

    public void setFragment(String fragment) {
        this.url = URLUtils.setEncodedFragment(this.url, fragment);
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("The HTTP connect timeout must be zero or positive");
        }
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("The HTTP response read timeout must be zero or positive");
        }
        this.readTimeout = readTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public X509Certificate getClientX509Certificate() {
        return this.clientX509Certificate;
    }

    public void setClientX509Certificate(X509Certificate clientX509Certificate) {
        this.clientX509Certificate = clientX509Certificate;
    }

    public String getClientX509CertificateSubjectDN() {
        return this.clientX509CertificateSubjectDN;
    }

    public void setClientX509CertificateSubjectDN(String subjectDN) {
        this.clientX509CertificateSubjectDN = subjectDN;
    }

    public String getClientX509CertificateRootDN() {
        return this.clientX509CertificateRootDN;
    }

    public void setClientX509CertificateRootDN(String rootDN) {
        this.clientX509CertificateRootDN = rootDN;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier defaultHostnameVerifier) {
        if (defaultHostnameVerifier == null) {
            throw new IllegalArgumentException("The hostname verifier must not be null");
        }
        HTTPRequest.defaultHostnameVerifier = defaultHostnameVerifier;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLSocketFactory;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        if (sslSocketFactory == null) {
            throw new IllegalArgumentException("The SSL socket factory must not be null");
        }
        defaultSSLSocketFactory = sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HttpURLConnection toHttpURLConnection(HostnameVerifier hostnameVerifier, SSLSocketFactory sslSocketFactory) throws IOException {
        HostnameVerifier savedHostnameVerifier = this.getHostnameVerifier();
        SSLSocketFactory savedSSLFactory = this.getSSLSocketFactory();
        try {
            this.setHostnameVerifier(hostnameVerifier);
            this.setSSLSocketFactory(sslSocketFactory);
            HttpURLConnection httpURLConnection = this.toHttpURLConnection();
            return httpURLConnection;
        }
        finally {
            this.setHostnameVerifier(savedHostnameVerifier);
            this.setSSLSocketFactory(savedSSLFactory);
        }
    }

    public HttpURLConnection toHttpURLConnection() throws IOException {
        URL finalURL = this.getURL();
        HttpURLConnection conn = (HttpURLConnection)(this.proxy == null ? finalURL.openConnection() : finalURL.openConnection(this.proxy));
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            sslConn.setHostnameVerifier(this.hostnameVerifier != null ? this.hostnameVerifier : HTTPRequest.getDefaultHostnameVerifier());
            sslConn.setSSLSocketFactory(this.sslSocketFactory != null ? this.sslSocketFactory : HTTPRequest.getDefaultSSLSocketFactory());
        }
        for (Map.Entry entry : this.getHeaderMap().entrySet()) {
            for (String headerValue : (List)entry.getValue()) {
                conn.addRequestProperty((String)entry.getKey(), headerValue);
            }
        }
        conn.setRequestMethod(this.method.name());
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        conn.setInstanceFollowRedirects(this.followRedirects);
        if (this.method.equals((Object)Method.POST) || this.method.equals((Object)Method.PUT)) {
            conn.setDoOutput(true);
            if (this.getEntityContentType() != null) {
                conn.setRequestProperty("Content-Type", this.getEntityContentType().toString());
            }
            if (this.getBody() != null) {
                OutputStream outputStream = null;
                try {
                    outputStream = conn.getOutputStream();
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                    outputStreamWriter.write(this.getBody());
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    HTTPRequest.closeStreams(conn.getInputStream(), outputStream, conn.getErrorStream(), this.debugCloseStreams);
                    throw iOException;
                }
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HTTPResponse send(HostnameVerifier hostnameVerifier, SSLSocketFactory sslSocketFactory) throws IOException {
        HostnameVerifier savedHostnameVerifier = this.getHostnameVerifier();
        SSLSocketFactory savedSSLFactory = this.getSSLSocketFactory();
        try {
            this.setHostnameVerifier(hostnameVerifier);
            this.setSSLSocketFactory(sslSocketFactory);
            HTTPResponse hTTPResponse = this.send();
            return hTTPResponse;
        }
        finally {
            this.setHostnameVerifier(savedHostnameVerifier);
            this.setSSLSocketFactory(savedSSLFactory);
        }
    }

    public HTTPResponse send() throws IOException {
        String line;
        int statusCode;
        BufferedReader reader;
        HttpURLConnection conn = this.toHttpURLConnection();
        InputStream inputStream = null;
        InputStream errStream = null;
        OutputStream outputStream = null;
        try {
            if (conn.getDoOutput()) {
                outputStream = conn.getOutputStream();
            }
            inputStream = conn.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            statusCode = conn.getResponseCode();
        }
        catch (IOException e) {
            statusCode = conn.getResponseCode();
            if (statusCode == -1) {
                throw e;
            }
            errStream = conn.getErrorStream();
            reader = errStream != null ? new BufferedReader(new InputStreamReader(errStream, StandardCharsets.UTF_8)) : new BufferedReader(new StringReader(""));
        }
        StringBuilder body = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            body.append(line);
            body.append(System.getProperty("line.separator"));
        }
        reader.close();
        HTTPResponse response = new HTTPResponse(statusCode);
        response.setStatusMessage(conn.getResponseMessage());
        for (Map.Entry<String, List<String>> responseHeader : conn.getHeaderFields().entrySet()) {
            List<String> values;
            if (responseHeader.getKey() == null || (values = responseHeader.getValue()) == null || values.isEmpty() || values.get(0) == null) continue;
            response.setHeader(responseHeader.getKey(), values.toArray(new String[0]));
        }
        HTTPRequest.closeStreams(inputStream, outputStream, errStream, this.debugCloseStreams);
        String bodyContent = body.toString();
        if (!bodyContent.isEmpty()) {
            response.setBody(bodyContent);
        }
        return response;
    }

    public HTTPResponse send(HTTPRequestSender httpRequestSender) throws IOException {
        ReadOnlyHTTPResponse roResponse = httpRequestSender.send(this);
        HTTPResponse response = new HTTPResponse(roResponse.getStatusCode());
        response.setStatusMessage(roResponse.getStatusMessage());
        for (Map.Entry<String, List<String>> en : roResponse.getHeaderMap().entrySet()) {
            if (en.getKey() == null || en.getValue() == null || en.getValue().isEmpty()) continue;
            response.setHeader(en.getKey(), en.getValue().toArray(new String[0]));
        }
        response.setBody(roResponse.getBody());
        return response;
    }

    private static void closeStreams(InputStream inputStream, OutputStream outputStream, InputStream errStream, boolean debugCloseStreams) throws IOException {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            if (debugCloseStreams) {
                throw e;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            if (debugCloseStreams) {
                throw e;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (errStream != null) {
                errStream.close();
            }
        }
        catch (IOException e) {
            if (debugCloseStreams) {
                throw e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

