/*
 * Decompiled with CFR 0.152.
 */
package io.trino.grammar.sql;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.trino.grammar.sql.SqlBaseLexer;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.Vocabulary;

public final class SqlKeywords {
    private static final Pattern IDENTIFIER = Pattern.compile("'([A-Z_]+)'");

    private SqlKeywords() {
    }

    public static Set<String> sqlKeywords() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        Vocabulary vocabulary = SqlBaseLexer.VOCABULARY;
        for (int i = 0; i <= vocabulary.getMaxTokenType(); ++i) {
            String name = Strings.nullToEmpty((String)vocabulary.getLiteralName(i));
            Matcher matcher = IDENTIFIER.matcher(name);
            if (!matcher.matches()) continue;
            names.add((Object)matcher.group(1));
        }
        return names.build();
    }
}

