/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.type;

import io.trino.plugin.base.type.AbstractTrinoTimestampEncoder;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import org.joda.time.DateTimeZone;

class LongTimestampEncoder
extends AbstractTrinoTimestampEncoder<LongTimestamp> {
    LongTimestampEncoder(TimestampType type, DateTimeZone timeZone) {
        super(type, timeZone);
    }

    @Override
    public void write(DecodedTimestamp decodedTimestamp, BlockBuilder blockBuilder) {
        LongTimestamp timestamp = this.getTimestamp(decodedTimestamp);
        this.type.writeObject(blockBuilder, (Object)timestamp);
    }

    @Override
    public LongTimestamp getTimestamp(DecodedTimestamp decodedTimestamp) {
        long adjustedSeconds = decodedTimestamp.epochSeconds();
        if (this.timeZone != DateTimeZone.UTC) {
            adjustedSeconds = this.timeZone.convertUTCToLocal(adjustedSeconds * 1000L) / 1000L;
        }
        int precision = this.type.getPrecision();
        int nanosOfSecond = decodedTimestamp.nanosOfSecond();
        if (precision < 9) {
            nanosOfSecond = (int)Timestamps.round((long)nanosOfSecond, (int)(9 - precision));
        }
        return TrinoTimestampEncoderFactory.longTimestamp(adjustedSeconds, (long)nanosOfSecond * 1000L);
    }
}

