/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.salesforce;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.trino.plugin.password.salesforce.SalesforceAuthenticationClient;
import io.trino.plugin.password.salesforce.SalesforceBasicAuthenticator;
import io.trino.plugin.password.salesforce.SalesforceConfig;
import io.trino.spi.security.PasswordAuthenticator;
import io.trino.spi.security.PasswordAuthenticatorFactory;
import java.util.Map;

public class SalesforceAuthenticatorFactory
implements PasswordAuthenticatorFactory {
    public String getName() {
        return "salesforce";
    }

    public PasswordAuthenticator create(Map<String, String> config) {
        Bootstrap app = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(SalesforceConfig.class);
            binder.bind(SalesforceBasicAuthenticator.class).in(Scopes.SINGLETON);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("salesforce-authenticator", SalesforceAuthenticationClient.class);
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (PasswordAuthenticator)injector.getInstance(SalesforceBasicAuthenticator.class);
    }
}

