/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.snappy;

import io.airlift.compress.v3.MalformedInputException;
import io.airlift.compress.v3.snappy.SnappyDecompressor;
import io.airlift.compress.v3.snappy.SnappyNative;
import java.lang.foreign.MemorySegment;

public final class SnappyNativeDecompressor
implements SnappyDecompressor {
    private final SnappyNative snappyNative = new SnappyNative();

    public SnappyNativeDecompressor() {
        SnappyNative.verifyEnabled();
    }

    public static boolean isEnabled() {
        return SnappyNative.isEnabled();
    }

    @Override
    public int getUncompressedLength(byte[] compressed, int compressedOffset) {
        MemorySegment input = MemorySegment.ofArray(compressed).asSlice(compressedOffset);
        long length = this.snappyNative.decompressedLength(input, input.byteSize());
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new MalformedInputException(0L, "invalid compressed length");
        }
        return Math.toIntExact(length);
    }

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)inputOffset, inputLength);
        MemorySegment outputSegment = MemorySegment.ofArray(output).asSlice((long)outputOffset, maxOutputLength);
        return this.decompress(inputSegment, outputSegment);
    }

    @Override
    public int decompress(MemorySegment input, MemorySegment output) {
        return Math.toIntExact(this.snappyNative.decompress(input, input.byteSize(), output, output.byteSize()));
    }
}

