/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import io.opencensus.trace.ContextHandle;
import io.opencensus.trace.ContextManager;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.opencensusshim.OpenTelemetryCtx;
import io.opentelemetry.opencensusshim.OpenTelemetryNoRecordEventsSpanImpl;
import io.opentelemetry.opencensusshim.OpenTelemetrySpanImpl;
import io.opentelemetry.opencensusshim.SpanConverter;
import java.util.logging.Logger;

public final class OpenTelemetryContextManager
implements ContextManager {
    private static final Logger LOGGER = Logger.getLogger(OpenTelemetryContextManager.class.getName());

    public ContextHandle currentContext() {
        return OpenTelemetryContextManager.wrapContext(Context.current());
    }

    public ContextHandle withValue(ContextHandle ctx, io.opencensus.trace.Span span) {
        if (!(ctx instanceof OpenTelemetryCtx)) {
            LOGGER.warning("ContextHandle is not an instance of OpenTelemetryCtx. There should not be a local implementation of ContextHandle other than OpenTelemetryCtx.");
        }
        OpenTelemetryCtx openTelemetryCtx = (OpenTelemetryCtx)ctx;
        if (span instanceof OpenTelemetrySpanImpl) {
            return OpenTelemetryContextManager.wrapContext(OpenTelemetryContextManager.unwrapContext(openTelemetryCtx).with((ImplicitContextKeyed)((OpenTelemetrySpanImpl)span)));
        }
        return OpenTelemetryContextManager.wrapContext(OpenTelemetryContextManager.unwrapContext(openTelemetryCtx).with((ImplicitContextKeyed)((OpenTelemetryNoRecordEventsSpanImpl)span)));
    }

    public io.opencensus.trace.Span getValue(ContextHandle ctx) {
        Span span = Span.fromContext((Context)OpenTelemetryContextManager.unwrapContext(ctx));
        if (span instanceof OpenTelemetrySpanImpl) {
            return (OpenTelemetrySpanImpl)span;
        }
        return SpanConverter.fromOtelSpan(span);
    }

    private static ContextHandle wrapContext(Context context) {
        return new OpenTelemetryCtx(context);
    }

    private static Context unwrapContext(ContextHandle ctx) {
        return ((OpenTelemetryCtx)ctx).getContext();
    }
}

