/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import com.google.common.base.Preconditions;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.opencensusshim.DelegatingSpan;
import io.opentelemetry.opencensusshim.SpanConverter;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Logger;

class OpenTelemetrySpanImpl
extends io.opencensus.trace.Span
implements Span,
DelegatingSpan {
    private static final Logger LOGGER = Logger.getLogger(OpenTelemetrySpanImpl.class.getName());
    private static final EnumSet<Span.Options> RECORD_EVENTS_SPAN_OPTIONS = EnumSet.of(Span.Options.RECORD_EVENTS);
    private final Span otelSpan;

    OpenTelemetrySpanImpl(Span otelSpan) {
        super(SpanConverter.mapSpanContext(otelSpan.getSpanContext()), RECORD_EVENTS_SPAN_OPTIONS);
        this.otelSpan = otelSpan;
    }

    @Override
    public Span getDelegate() {
        return this.otelSpan;
    }

    public void putAttribute(String key, AttributeValue value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        value.match(arg -> DelegatingSpan.super.setAttribute(key, (String)arg), arg -> DelegatingSpan.super.setAttribute(key, (boolean)arg), arg -> DelegatingSpan.super.setAttribute(key, (long)arg), arg -> DelegatingSpan.super.setAttribute(key, (double)arg), arg -> null);
    }

    public void putAttributes(Map<String, AttributeValue> attributes) {
        Preconditions.checkNotNull(attributes, (Object)"attributes");
        attributes.forEach(this::putAttribute);
    }

    public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetrySpanImpl.mapAttributes(attributes, attributesBuilder);
        DelegatingSpan.super.addEvent(description, attributesBuilder.build());
    }

    public void addAnnotation(Annotation annotation) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetrySpanImpl.mapAttributes(annotation.getAttributes(), attributesBuilder);
        DelegatingSpan.super.addEvent(annotation.getDescription(), attributesBuilder.build());
    }

    public void addLink(Link link) {
        LOGGER.warning("OpenTelemetry does not support links added after a span is created.");
    }

    public void addMessageEvent(MessageEvent messageEvent) {
        DelegatingSpan.super.addEvent(String.valueOf(messageEvent.getMessageId()), Attributes.of((AttributeKey)AttributeKey.stringKey((String)"message.event.type"), (Object)messageEvent.getType().toString(), (AttributeKey)AttributeKey.longKey((String)"message.event.size.uncompressed"), (Object)messageEvent.getUncompressedMessageSize(), (AttributeKey)AttributeKey.longKey((String)"message.event.size.compressed"), (Object)messageEvent.getCompressedMessageSize()));
    }

    public void setStatus(Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        DelegatingSpan.super.setStatus(status.isOk() ? StatusCode.OK : StatusCode.ERROR);
    }

    @Override
    public Span setStatus(StatusCode canonicalCode, String description) {
        return DelegatingSpan.super.setStatus(canonicalCode, description);
    }

    public void end(EndSpanOptions options) {
        DelegatingSpan.super.end();
    }

    @Override
    public SpanContext getSpanContext() {
        return DelegatingSpan.super.getSpanContext();
    }

    @Override
    public boolean isRecording() {
        return true;
    }

    private static void mapAttributes(Map<String, AttributeValue> attributes, AttributesBuilder attributesBuilder) {
        attributes.forEach((s, attributeValue) -> attributeValue.match(SpanConverter.setStringAttribute(attributesBuilder, s), SpanConverter.setBooleanAttribute(attributesBuilder, s), SpanConverter.setLongAttribute(attributesBuilder, s), SpanConverter.setDoubleAttribute(attributesBuilder, s), arg -> null));
    }
}

