/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.TimeStat;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.metrics.SdkMetric;

@ThreadSafe
public class AwsSdkV2HttpClientStats {
    private final TimeStat connectionAcquireLatency = new TimeStat(TimeUnit.MILLISECONDS);
    private final AtomicLong availableConcurrency = new AtomicLong();
    private final AtomicLong leasedConcurrency = new AtomicLong();
    private final AtomicLong pendingConcurrencyAcquires = new AtomicLong();

    @Managed
    @Nested
    public TimeStat getConnectionAcquireLatency() {
        return this.connectionAcquireLatency;
    }

    @Managed
    public long getAvailableConcurrency() {
        return this.availableConcurrency.get();
    }

    @Managed
    public long getLeasedConcurrency() {
        return this.leasedConcurrency.get();
    }

    @Managed
    public long getPendingConcurrencyAcquires() {
        return this.pendingConcurrencyAcquires.get();
    }

    public void updateConcurrencyStats(SdkMetric<?> metric, int value) {
        if (metric.equals((Object)HttpMetric.AVAILABLE_CONCURRENCY)) {
            this.availableConcurrency.set(value);
        } else if (metric.equals((Object)HttpMetric.PENDING_CONCURRENCY_ACQUIRES)) {
            this.pendingConcurrencyAcquires.set(value);
        } else if (metric.equals((Object)HttpMetric.LEASED_CONCURRENCY)) {
            this.leasedConcurrency.set(value);
        }
    }

    public void updateConcurrencyAcquireDuration(Duration duration) {
        this.connectionAcquireLatency.addNanos(duration.toNanos());
    }
}

