/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.trino.filesystem.s3.S3FileSystemModule;
import io.trino.filesystem.s3.S3SecurityMappingConfig;
import io.trino.filesystem.s3.S3SecurityMappings;
import io.trino.plugin.base.util.JsonUtils;
import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;

class S3SecurityMappingsUriSource
implements Supplier<S3SecurityMappings> {
    private final URI configUri;
    private final HttpClient httpClient;
    private final String jsonPointer;

    @Inject
    public S3SecurityMappingsUriSource(S3SecurityMappingConfig config, @S3FileSystemModule.ForS3SecurityMapping HttpClient httpClient) {
        this.configUri = config.getConfigUri().orElseThrow();
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.jsonPointer = config.getJsonPointer();
    }

    @Override
    public S3SecurityMappings get() {
        return (S3SecurityMappings)JsonUtils.parseJson((String)this.getRawJsonString(), (String)this.jsonPointer, S3SecurityMappings.class);
    }

    @VisibleForTesting
    String getRawJsonString() {
        Request request = Request.Builder.prepareGet().setUri(this.configUri).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        int status = response.getStatusCode();
        if (status != HttpStatus.OK.code()) {
            throw new RuntimeException("Request to '%s' returned unexpected status code: %s".formatted(this.configUri, status));
        }
        return response.getBody();
    }
}

