/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.encryption.EncryptionKey;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

final class S3SseCUtils {
    private S3SseCUtils() {
    }

    public static String encoded(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(key.key());
    }

    public static String md5Checksum(EncryptionKey key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(key.key());
            return Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

