/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.resourcegroups.ManagerSpec;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.ResourceGroupNameTemplate;
import io.trino.plugin.resourcegroups.ResourceGroupSelector;
import io.trino.plugin.resourcegroups.ResourceGroupSpec;
import io.trino.plugin.resourcegroups.SelectorSpec;
import io.trino.plugin.resourcegroups.StaticSelector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.memory.ClusterMemoryPoolManager;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroup;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractResourceConfigurationManager
implements ResourceGroupConfigurationManager<ResourceGroupIdTemplate> {
    @GuardedBy(value="memoryPoolFraction")
    private final Map<ResourceGroup, Double> memoryPoolFraction = new HashMap<ResourceGroup, Double>();
    @GuardedBy(value="memoryPoolFraction")
    private long memoryPoolBytes;

    protected abstract Optional<Duration> getCpuQuotaPeriod();

    protected abstract List<ResourceGroupSpec> getRootGroups();

    protected void validateRootGroups(ManagerSpec managerSpec) {
        LinkedList<ResourceGroupSpec> groups = new LinkedList<ResourceGroupSpec>(managerSpec.getRootGroups());
        block4: while (!groups.isEmpty()) {
            ResourceGroupSpec group = (ResourceGroupSpec)groups.poll();
            List<ResourceGroupSpec> subGroups = group.getSubGroups();
            groups.addAll(subGroups);
            if (group.getSoftCpuLimit().isPresent() || group.getHardCpuLimit().isPresent()) {
                Preconditions.checkArgument((boolean)managerSpec.getCpuQuotaPeriod().isPresent(), (String)"cpuQuotaPeriod must be specified to use CPU limits on group: %s", (Object)group.getName());
            }
            if (group.getSoftCpuLimit().isPresent()) {
                Preconditions.checkArgument((boolean)group.getHardCpuLimit().isPresent(), (Object)"Must specify hard CPU limit in addition to soft limit");
                Preconditions.checkArgument((group.getSoftCpuLimit().get().compareTo(group.getHardCpuLimit().get()) <= 0 ? 1 : 0) != 0, (Object)"Soft CPU limit cannot be greater than hard CPU limit");
            }
            if (!group.getSchedulingPolicy().isPresent()) continue;
            switch (group.getSchedulingPolicy().get()) {
                case WEIGHTED: 
                case WEIGHTED_FAIR: {
                    Preconditions.checkArgument((subGroups.stream().allMatch(t -> t.getSchedulingWeight().isPresent()) || subGroups.stream().noneMatch(t -> t.getSchedulingWeight().isPresent()) ? 1 : 0) != 0, (String)"Must specify scheduling weight for all sub-groups of '%s' or none of them", (Object)group.getName());
                    break;
                }
                case QUERY_PRIORITY: 
                case FAIR: {
                    for (ResourceGroupSpec subGroup : subGroups) {
                        Preconditions.checkArgument((boolean)subGroup.getSchedulingWeight().isEmpty(), (String)"Must use 'weighted' or 'weighted_fair' scheduling policy if specifying scheduling weight for '%s'", (Object)group.getName());
                    }
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    protected List<ResourceGroupSelector> buildSelectors(ManagerSpec managerSpec) {
        ImmutableList.Builder selectors = ImmutableList.builder();
        for (SelectorSpec spec : managerSpec.getSelectors()) {
            this.validateSelectors(managerSpec.getRootGroups(), spec);
            selectors.add((Object)new StaticSelector(spec.getUserRegex(), spec.getUserGroupRegex(), spec.getOriginalUserRegex(), spec.getAuthenticatedUserRegex(), spec.getSourceRegex(), spec.getClientTags(), spec.getResourceEstimate(), spec.getQueryType(), spec.getGroup()));
        }
        return selectors.build();
    }

    private void validateSelectors(List<ResourceGroupSpec> groups, SelectorSpec spec) {
        spec.getQueryType().ifPresent(this::validateQueryType);
        StringBuilder fullyQualifiedGroupName = new StringBuilder();
        for (ResourceGroupNameTemplate groupName : spec.getGroup().getSegments()) {
            fullyQualifiedGroupName.append(groupName);
            ResourceGroupSpec match = groups.stream().filter(groupSpec -> groupSpec.getName().equals(groupName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Selector refers to nonexistent group: %s", fullyQualifiedGroupName)));
            fullyQualifiedGroupName.append(".");
            groups = match.getSubGroups();
        }
    }

    private void validateQueryType(String queryType) {
        try {
            QueryType.valueOf((String)queryType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Selector specifies an invalid query type: %s", queryType));
        }
    }

    protected AbstractResourceConfigurationManager(ClusterMemoryPoolManager memoryPoolManager) {
        memoryPoolManager.addChangeListener(poolInfo -> {
            HashMap<ResourceGroup, DataSize> memoryLimits = new HashMap<ResourceGroup, DataSize>();
            Map<ResourceGroup, Double> map = this.memoryPoolFraction;
            synchronized (map) {
                for (Map.Entry<ResourceGroup, Double> entry : this.memoryPoolFraction.entrySet()) {
                    long bytes = Math.round((double)poolInfo.getMaxBytes() * entry.getValue());
                    memoryLimits.put(entry.getKey(), DataSize.ofBytes((long)bytes));
                }
                this.memoryPoolBytes = poolInfo.getMaxBytes();
            }
            memoryLimits.forEach((group, limit) -> group.setSoftMemoryLimitBytes(limit.toBytes()));
        });
    }

    public SelectionContext<ResourceGroupIdTemplate> parentGroupContext(SelectionContext<ResourceGroupIdTemplate> context) {
        ResourceGroupId parentGroupId = (ResourceGroupId)context.getResourceGroupId().getParent().orElseThrow(() -> new IllegalArgumentException("Group has no parent group: " + String.valueOf(context.getResourceGroupId())));
        ArrayList<ResourceGroupNameTemplate> parentGroupIdTemplate = new ArrayList<ResourceGroupNameTemplate>(((ResourceGroupIdTemplate)context.getContext()).getSegments());
        parentGroupIdTemplate.remove(parentGroupIdTemplate.size() - 1);
        return new SelectionContext(parentGroupId, (Object)ResourceGroupIdTemplate.fromSegments(parentGroupIdTemplate));
    }

    protected ResourceGroupSpec getMatchingSpec(ResourceGroup group, SelectionContext<ResourceGroupIdTemplate> context) {
        List<ResourceGroupSpec> candidates = this.getRootGroups();
        ResourceGroupIdTemplate groupIdTemplate = (ResourceGroupIdTemplate)context.getContext();
        ResourceGroupSpec match = null;
        for (ResourceGroupNameTemplate segment : groupIdTemplate.getSegments()) {
            match = null;
            for (ResourceGroupSpec candidate : candidates) {
                if (!candidate.getName().equals(segment)) continue;
                if (match != null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_RESOURCE_GROUP, String.format("Ambiguous configuration for [%s] using [%s]. Matches [%s] and [%s]", group.getId(), groupIdTemplate, match.getName(), candidate.getName()));
                }
                match = candidate;
            }
            Preconditions.checkState((match != null ? 1 : 0) != 0, (String)"No matching configuration found for [%s] using [%s]", (Object)group.getId(), (Object)groupIdTemplate);
            candidates = match.getSubGroups();
        }
        Verify.verifyNotNull(match, (String)"match is null", (Object[])new Object[0]);
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureGroup(ResourceGroup group, ResourceGroupSpec match) {
        Map<ResourceGroup, Double> map;
        if (match.getSoftMemoryLimit().isPresent()) {
            map = this.memoryPoolFraction;
            synchronized (map) {
                this.memoryPoolFraction.remove(group);
                group.setSoftMemoryLimitBytes(match.getSoftMemoryLimit().get().toBytes());
            }
        }
        map = this.memoryPoolFraction;
        synchronized (map) {
            double fraction = match.getSoftMemoryLimitFraction().get();
            this.memoryPoolFraction.put(group, fraction);
            group.setSoftMemoryLimitBytes((long)((double)this.memoryPoolBytes * fraction));
        }
        group.setMaxQueuedQueries(match.getMaxQueued());
        group.setSoftConcurrencyLimit(match.getSoftConcurrencyLimit().orElse(match.getHardConcurrencyLimit()).intValue());
        group.setHardConcurrencyLimit(match.getHardConcurrencyLimit());
        match.getSchedulingPolicy().ifPresent(arg_0 -> ((ResourceGroup)group).setSchedulingPolicy(arg_0));
        match.getSchedulingWeight().ifPresent(arg_0 -> ((ResourceGroup)group).setSchedulingWeight(arg_0));
        match.getJmxExport().filter(Predicate.isEqual(group.getJmxExport()).negate()).ifPresent(arg_0 -> ((ResourceGroup)group).setJmxExport(arg_0));
        match.getSoftCpuLimit().map(Duration::toMillis).map(java.time.Duration::ofMillis).ifPresent(arg_0 -> ((ResourceGroup)group).setSoftCpuLimit(arg_0));
        match.getHardCpuLimit().map(Duration::toMillis).map(java.time.Duration::ofMillis).ifPresent(arg_0 -> ((ResourceGroup)group).setHardCpuLimit(arg_0));
        if (match.getSoftCpuLimit().isPresent() || match.getHardCpuLimit().isPresent()) {
            Preconditions.checkState((boolean)this.getCpuQuotaPeriod().isPresent(), (String)"cpuQuotaPeriod must be specified to use CPU limits on group: %s", (Object)group.getId());
            Duration limit = match.getHardCpuLimit().isPresent() ? match.getHardCpuLimit().get() : match.getSoftCpuLimit().get();
            long rate = (long)Math.min(1000.0 * (double)limit.toMillis() / (double)this.getCpuQuotaPeriod().get().toMillis(), 9.223372036854776E18);
            rate = Math.max(1L, rate);
            group.setCpuQuotaGenerationMillisPerSecond(rate);
        }
    }
}

