/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.ResourceGroupSelector;
import io.trino.plugin.resourcegroups.SelectorResourceEstimate;
import io.trino.plugin.resourcegroups.VariableMap;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticSelector
implements ResourceGroupSelector {
    private static final Pattern NAMED_GROUPS_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private static final String USER_VARIABLE = "USER";
    private static final String SOURCE_VARIABLE = "SOURCE";
    private final Optional<Pattern> userRegex;
    private final ResourceGroupIdTemplate group;
    private final List<SelectionMatcher> selectionMatchers;

    public StaticSelector(Optional<Pattern> userRegex, Optional<Pattern> userGroupRegex, Optional<Pattern> originalUserRegex, Optional<Pattern> authenticatedUserRegex, Optional<Pattern> sourceRegex, Optional<List<String>> clientTags, Optional<SelectorResourceEstimate> selectorResourceEstimate, Optional<String> queryType, ResourceGroupIdTemplate group) {
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        Objects.requireNonNull(userGroupRegex, "userGroupRegex is null");
        Objects.requireNonNull(originalUserRegex, "originalUserRegex is null");
        Objects.requireNonNull(authenticatedUserRegex, "authenticatedUserRegex is null");
        Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        Objects.requireNonNull(clientTags, "clientTags is null");
        Objects.requireNonNull(selectorResourceEstimate, "selectorResourceEstimate is null");
        Objects.requireNonNull(queryType, "queryType is null");
        this.group = Objects.requireNonNull(group, "group is null");
        HashSet variableNames = new HashSet(ImmutableList.of((Object)USER_VARIABLE, (Object)SOURCE_VARIABLE));
        this.selectionMatchers = ImmutableList.builder().add(userRegex.map(userRegexValue -> {
            StaticSelector.addNamedGroups(userRegexValue, variableNames);
            return new PatternMatcher(variableNames, (Pattern)userRegexValue, SelectionCriteria::getUser);
        })).add(originalUserRegex.map(originalUserRegexValue -> {
            StaticSelector.addNamedGroups(originalUserRegexValue, variableNames);
            return new PatternMatcher(variableNames, (Pattern)originalUserRegexValue, SelectionCriteria::getOriginalUser);
        })).add(authenticatedUserRegex.map(authenticatedUserRegexValue -> {
            StaticSelector.addNamedGroups(authenticatedUserRegexValue, variableNames);
            return new PatternMatcher(variableNames, (Pattern)authenticatedUserRegexValue, criteria -> criteria.getAuthenticatedUser().orElse(""));
        })).add(sourceRegex.map(sourceRegexValue -> {
            StaticSelector.addNamedGroups(sourceRegexValue, variableNames);
            return new PatternMatcher(variableNames, (Pattern)sourceRegexValue, criteria -> criteria.getSource().orElse(""));
        })).add(userGroupRegex.map(userGroupRegexValue -> new BasicMatcher(criteria -> criteria.getUserGroups().stream().anyMatch(userGroup -> userGroupRegexValue.matcher((CharSequence)userGroup).matches())))).add(queryType.map(queryTypeValue -> new BasicMatcher(criteria -> queryTypeValue.equalsIgnoreCase(criteria.getQueryType().orElse(""))))).add(selectorResourceEstimate.map(selectorResourceEstimateValue -> new BasicMatcher(criteria -> selectorResourceEstimateValue.match(criteria.getResourceEstimates())))).add(clientTags.map(clientTagsValue -> new BasicMatcher(criteria -> criteria.getTags().containsAll((Collection<?>)clientTagsValue)))).build().stream().flatMap(Optional::stream).toList();
        Sets.SetView unresolvedVariables = Sets.difference(group.getVariableNames(), variableNames);
        Preconditions.checkArgument((boolean)unresolvedVariables.isEmpty(), (String)"unresolved variables %s in resource group ID '%s', available: %s\"", (Object)unresolvedVariables, (Object)group, variableNames);
    }

    @Override
    public Optional<SelectionContext<ResourceGroupIdTemplate>> match(SelectionCriteria criteria) {
        if (!this.selectionMatchers.stream().allMatch(matcher -> matcher.matches(criteria))) {
            return Optional.empty();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        for (SelectionMatcher matcher2 : this.selectionMatchers) {
            matcher2.populateVariables(criteria, variables);
        }
        variables.putIfAbsent(USER_VARIABLE, criteria.getUser());
        variables.putIfAbsent(SOURCE_VARIABLE, criteria.getSource().orElse(""));
        ResourceGroupId id = this.group.expandTemplate(new VariableMap(variables));
        return Optional.of(new SelectionContext(id, (Object)this.group));
    }

    private static void addNamedGroups(Pattern pattern, HashSet<String> variables) {
        Matcher matcher = NAMED_GROUPS_PATTERN.matcher(pattern.toString());
        while (matcher.find()) {
            String name = matcher.group(1);
            Preconditions.checkArgument((!variables.contains(name) ? 1 : 0) != 0, (Object)("Multiple definitions found for variable ${" + name + "}"));
            variables.add(name);
        }
    }

    @VisibleForTesting
    public Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    private static interface SelectionMatcher {
        public boolean matches(SelectionCriteria var1);

        public void populateVariables(SelectionCriteria var1, Map<String, String> var2);
    }

    private record BasicMatcher(Predicate<SelectionCriteria> matchPredicate) implements SelectionMatcher
    {
        @Override
        public boolean matches(SelectionCriteria criteria) {
            return this.matchPredicate.test(criteria);
        }

        @Override
        public void populateVariables(SelectionCriteria criteria, Map<String, String> variables) {
        }
    }

    private record PatternMatcher(Set<String> variableNames, Pattern pattern, Function<SelectionCriteria, String> valueExtractor) implements SelectionMatcher
    {
        @Override
        public boolean matches(SelectionCriteria criteria) {
            return this.pattern.matcher(this.valueExtractor.apply(criteria)).matches();
        }

        @Override
        public void populateVariables(SelectionCriteria criteria, Map<String, String> variables) {
            Matcher matcher = this.pattern.matcher(this.valueExtractor.apply(criteria));
            if (!matcher.matches()) {
                return;
            }
            Map<String, Integer> namedGroups = matcher.namedGroups();
            for (String key : this.variableNames) {
                String value;
                if (!namedGroups.containsKey(key) || (value = matcher.group(namedGroups.get(key))) == null) continue;
                variables.put(key, value);
            }
        }
    }
}

