/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.TemplateOverflow;

class DatabaseSessionState
implements oracle.jdbc.internal.DatabaseSessionState,
Diagnosable {
    private static final String CLASS_NAME = DatabaseSessionState.class.getName();
    StateSignatures stateSignatures = null;
    long templateId = 0L;
    byte[] fullOverflow = null;
    List<byte[]> deltaOverflows;
    private UpdatesSinceLastCopy updatesSinceLastCopy = UpdatesSinceLastCopy.NO_UPDATES;
    private DatabaseSessionState currentCopy = null;
    private static final long SIG_FLAGS_SERVER_RESTORABLE_CHANGES = 4L;
    private static final long SIG_FLAGS_UNRESTORABLE_CHANGES = 32L;

    DatabaseSessionState() {
        this.deltaOverflows = new ArrayList<byte[]>();
    }

    @Override
    public oracle.jdbc.internal.StateSignatures getStateSignatures() {
        return this.stateSignatures;
    }

    @Override
    public long getId() {
        return this.templateId;
    }

    @Override
    public byte[] getCheckpoint() {
        return this.fullOverflow;
    }

    @Override
    public List<byte[]> getUpdates() {
        return this.deltaOverflows;
    }

    DatabaseSessionState copy() {
        if (this.currentCopy == null) {
            this.currentCopy = new DatabaseSessionState();
        }
        switch (this.updatesSinceLastCopy) {
            case NO_UPDATES: {
                break;
            }
            case ONLY_SIGNATURE_UPDATES: {
                this.currentCopy.stateSignatures = this.stateSignatures.copy();
                break;
            }
            case BOTH_SIGNATURE_AND_TEMPLATE_UPDATES: {
                this.currentCopy.stateSignatures = this.stateSignatures.copy();
                this.currentCopy.templateId = this.templateId;
                if (this.fullOverflow != null && this.fullOverflow.length > 0) {
                    this.currentCopy.fullOverflow = new byte[this.fullOverflow.length];
                    System.arraycopy(this.fullOverflow, 0, this.currentCopy.fullOverflow, 0, this.fullOverflow.length);
                }
                this.currentCopy.deltaOverflows = new ArrayList<byte[]>();
                for (byte[] deltaOverflow : this.deltaOverflows) {
                    if (deltaOverflow == null || deltaOverflow.length <= 0) continue;
                    byte[] deltaCopy = new byte[deltaOverflow.length];
                    System.arraycopy(deltaOverflow, 0, deltaCopy, 0, deltaOverflow.length);
                    this.currentCopy.deltaOverflows.add(deltaCopy);
                }
                break;
            }
        }
        this.updatesSinceLastCopy = UpdatesSinceLastCopy.NO_UPDATES;
        return this.currentCopy;
    }

    final void update(StateSignatures stateSignatures, TemplateOverflow templateOverflow) {
        this.stateSignatures = stateSignatures;
        this.stateSignatures.signatureFlags &= 0xFFFFFFFFFFFFFFBFL;
        this.updatesSinceLastCopy = UpdatesSinceLastCopy.ONLY_SIGNATURE_UPDATES;
        if (templateOverflow != null) {
            this.templateId = templateOverflow.getTemplateId();
            byte[] overflow = templateOverflow.getOverflow();
            boolean full = templateOverflow.isOverflowComplete();
            if (full && overflow != null) {
                this.fullOverflow = overflow;
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "Full state", null, null);
                this.updatesSinceLastCopy = UpdatesSinceLastCopy.BOTH_SIGNATURE_AND_TEMPLATE_UPDATES;
            } else if (!full && overflow != null) {
                if (this.fullOverflow == null) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "Server sent delta-overflow without first sending full-overflow", null, null);
                } else {
                    this.deltaOverflows.add(overflow);
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "Delta state", null, null);
                    this.updatesSinceLastCopy = UpdatesSinceLastCopy.BOTH_SIGNATURE_AND_TEMPLATE_UPDATES;
                }
            } else if (full && overflow == null) {
                this.fullOverflow = null;
                this.deltaOverflows = new ArrayList<byte[]>();
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "Clear state", null, null);
                this.updatesSinceLastCopy = UpdatesSinceLastCopy.BOTH_SIGNATURE_AND_TEMPLATE_UPDATES;
            }
        }
    }

    public String toString() {
        return "DatabaseSessionState[StateSignatures=" + this.stateSignatures + ", TemplateID=" + Long.toHexString(this.getId()) + ", Full-overflow: " + (this.fullOverflow == null ? 0 : 1) + ", Delta-overflow: " + this.deltaOverflows.size() + "]";
    }

    boolean isUnrestorable() {
        return this.stateSignatures != null && (this.stateSignatures.getSignatureFlags() & 0x24L) > 0L;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    private static enum UpdatesSinceLastCopy {
        NO_UPDATES,
        ONLY_SIGNATURE_UPDATES,
        BOTH_SIGNATURE_AND_TEMPLATE_UPDATES;

    }
}

