/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.OsonValueFactory;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public abstract class OsonStructureImpl {
    OsonContext ctx;
    int pos;
    public int size;
    byte childOffsetUb;
    int childArrayOffset;

    public OsonStructureImpl(OsonContext ctx) {
        this.ctx = ctx;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    void init(int pos) {
        this.pos = pos;
    }

    void initChildOffseUb(int op) {
        this.childOffsetUb = (op & 0x20) != 0 ? (byte)4 : (byte)2;
    }

    Boolean getBooleanInternal(int offset) {
        int op = this.ctx.b.getUB1(offset);
        if (op < 0) {
            return null;
        }
        if (op == 49) {
            return true;
        }
        if (op == 50) {
            return false;
        }
        return null;
    }

    String getStringInternal(int offset) {
        int op = this.ctx.b.getUB1(offset);
        if (op < 0) {
            return null;
        }
        if (op <= 31) {
            this.ctx.b.position(offset + 1);
            return this.ctx.b.readString(op);
        }
        if (op == 51) {
            int len = this.ctx.b.getUB1(offset + 1);
            this.ctx.b.position(offset + 2);
            return this.ctx.b.readString(len);
        }
        if (op == 55) {
            int len = this.ctx.b.getUB2(offset + 1);
            this.ctx.b.position(offset + 3);
            return this.ctx.b.readString(len);
        }
        if (op == 56) {
            int len = this.ctx.b.getUB4int(offset + 1);
            this.ctx.b.position(offset + 5);
            return this.ctx.b.readString(len);
        }
        return null;
    }

    boolean isNullInternal(int childOffset) {
        int op = this.ctx.b.getUB1(childOffset);
        if (op < 0) {
            return false;
        }
        return op == 48;
    }

    public Object getValueInternal(int offset) {
        return OsonStructureImpl.getValueInternal(offset, this.ctx.getFactory(), this.ctx);
    }

    public static Object getValueInternal(int offset, OsonValueFactory factory, OsonContext ctx) {
        int op = ctx.b.getUB1(offset);
        if ((op & 0xC0) == 192) {
            return factory.createArray(ctx, offset);
        }
        if ((op & 0xC0) == 128) {
            if ((op & 0x83) == 131) {
                return OsonStructureImpl.getOverflowValue(offset, factory, ctx);
            }
            return factory.createObject(ctx, offset);
        }
        if (op <= 31) {
            return factory.createString(ctx, offset + 1, op);
        }
        if (OsonConstants.isSB4(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, op & 7, ctx), OracleJsonDecimal.TargetType.INT);
        }
        if (OsonConstants.isSB8(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, op & 0xF, ctx), OracleJsonDecimal.TargetType.LONG);
        }
        if (OsonConstants.isOraNum16(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, (op & 0xF) + 1, ctx), null);
        }
        if (OsonConstants.isDec_16(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, (op & 0xF) + 1, ctx), OracleJsonDecimal.TargetType.DECIMAL);
        }
        switch (op) {
            case 49: {
                return factory.createTrue();
            }
            case 50: {
                return factory.createFalse();
            }
            case 48: {
                return factory.createNull();
            }
            case 51: {
                int len = ctx.b.getUB1(offset + 1);
                return factory.createString(ctx, offset + 2, len);
            }
            case 55: {
                int len = ctx.b.getUB2(offset + 1);
                return factory.createString(ctx, offset + 3, len);
            }
            case 56: {
                int len = ctx.b.getUB4int(offset + 1);
                ctx.b.position(offset + 5);
                return factory.createString(ctx, offset + 5, len);
            }
            case 54: {
                ctx.b.position(offset + 1);
                return factory.createDouble(ctx.b.readDtyDouble());
            }
            case 127: {
                ctx.b.position(offset + 1);
                return factory.createFloat(ctx.b.readDtyFloat());
            }
            case 53: {
                int len = ctx.b.getUB1(offset + 1);
                ctx.b.position(offset + 2);
                String num = ctx.b.readString(len);
                return factory.createStringNumber(num);
            }
            case 52: {
                byte[] raw = OsonStructureImpl.readRaw(offset + 2, ctx.b.getUB1(offset + 1), ctx);
                return factory.createNumber(raw, null);
            }
            case 116: {
                byte[] raw = OsonStructureImpl.readRaw(offset + 2, ctx.b.getUB1(offset + 1), ctx);
                return factory.createNumber(raw, OracleJsonDecimal.TargetType.DECIMAL);
            }
            case 126: {
                int len = ctx.b.getUB1(offset + 1);
                if (len > 127 || len < 0) {
                    throw new UnsupportedOperationException(String.valueOf(op));
                }
                return factory.createBinary(ctx, offset + 2, len, true);
            }
            case 58: {
                int len = ctx.b.getUB2(offset + 1);
                return factory.createBinary(ctx, offset + 3, len, false);
            }
            case 59: {
                int len = ctx.b.getUB4int(offset + 1);
                return factory.createBinary(ctx, offset + 5, len, false);
            }
            case 57: 
            case 125: {
                return factory.createTimestamp(OsonStructureImpl.readTimestamp(ctx.b, offset));
            }
            case 124: {
                return factory.createTimestampTZ(OsonStructureImpl.readTimestampTZ(ctx.b, offset));
            }
            case 60: {
                return factory.createDate(OsonStructureImpl.readRaw(offset + 1, 7, ctx));
            }
            case 61: {
                return factory.createIntervalYM(OsonStructureImpl.readRaw(offset + 1, 5, ctx));
            }
            case 62: {
                return factory.createIntervalDS(OsonStructureImpl.readRaw(offset + 1, 11, ctx));
            }
            case 117: {
                return OsonStructureImpl.getOverflowValue(offset, factory, ctx);
            }
            case 118: {
                return OsonStructureImpl.getForwardedValue(ctx.b.getUB2(offset + 1), factory, ctx);
            }
            case 119: {
                return OsonStructureImpl.getForwardedValue(ctx.b.getUB4int(offset + 1), factory, ctx);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(op));
    }

    private static Object getForwardedValue(int relativeOffset, OsonValueFactory factory, OsonContext ctx) {
        int fwd = relativeOffset + ctx.header.extendedTreeSegmentOffset;
        return OsonStructureImpl.getValueInternal(fwd, factory, ctx);
    }

    private static Object getOverflowValue(int absoluteOffset, OsonValueFactory factory, OsonContext ctx) {
        int relativeOffset = absoluteOffset - ctx.header.treeSegmentOffset;
        OsonHeader header = ctx.header;
        int fwd = header.forwardingAddress.get(relativeOffset) + header.extendedTreeSegmentOffset;
        return OsonStructureImpl.getValueInternal(fwd, factory, ctx);
    }

    private static byte[] readRaw(int offset, int len, OsonContext ctx) {
        ctx.b.position(offset);
        byte[] res = new byte[len];
        ctx.b.get(res);
        return res;
    }

    protected static byte[] readTimestamp(OsonBuffer b, int offset) {
        int len;
        int op = b.getUB1(offset);
        if (op == 125) {
            len = OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC;
        } else if (op == 57) {
            len = OsonPrimitiveConversions.SIZE_TIMESTAMP;
        } else {
            throw new ClassCastException();
        }
        byte[] raw = new byte[len];
        b.position(offset + 1);
        b.get(raw);
        return raw;
    }

    protected static byte[] readTimestampTZ(OsonBuffer b, int offset) {
        byte[] raw = new byte[OsonPrimitiveConversions.SIZE_TIMESTAMPTZ];
        b.position(offset + 1);
        b.get(raw);
        return raw;
    }

    protected OsonAbstractArray getArrayInternal(int childOffset) {
        int op = this.ctx.b.getUB1(childOffset);
        if ((op & 0xC0) == 192) {
            return this.ctx.getFactory().createArray(this.ctx, childOffset);
        }
        throw new ClassCastException();
    }

    protected OsonAbstractObject getJsonObjectInternal(int childOffset) {
        int op = this.ctx.b.getUB1(childOffset);
        if ((op & 0xC0) == 128) {
            return this.ctx.getFactory().createObject(this.ctx, childOffset);
        }
        throw new ClassCastException();
    }

    protected abstract int getChildOffset(int var1);

    public abstract OracleJsonValue.OracleJsonType getOracleJsonType();

    public ByteBuffer getBuffer() {
        ByteBuffer b = this.ctx.b.buffer;
        b.position(0);
        return b;
    }

    public boolean isRoot() {
        return this.pos == this.ctx.header.getTreeSegmentOffset();
    }

    public abstract class PositionIter<T>
    implements Iterator<T> {
        protected int ipos = 0;

        @Override
        public boolean hasNext() {
            return this.ipos < OsonStructureImpl.this.size;
        }

        @Override
        public T next() {
            if (this.ipos >= OsonStructureImpl.this.size) {
                throw new NoSuchElementException();
            }
            return this.getValue(this.ipos++);
        }

        public abstract T getValue(int var1);
    }
}

