/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonGeneratorImpl;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.parser.JsonParserImpl;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public final class OracleJsonFactory {
    private static final boolean DISABLE_GENERATOR_POOL = Boolean.getBoolean("oracle.sql.json.OracleJsonFactory.DISABLE_GENERATOR_POOL");
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final OsonGeneratorImpl.OsonGeneratorStatePool generatorPool = DISABLE_GENERATOR_POOL ? null : new OsonGeneratorImpl.OsonGeneratorStatePool();
    private final BufferPoolImpl bufferPool = new BufferPoolImpl();

    public OracleJsonParser createJsonBinaryParser(InputStream in) throws OracleJsonException {
        byte[] bytes = OracleJsonFactory.readInputStream(in);
        ByteBuffer b = ByteBuffer.wrap(bytes);
        OsonContext ctx = new OsonContext(new OsonBuffer(b));
        OsonParserImpl result = new OsonParserImpl(ctx);
        result.setCloseable(in);
        return result;
    }

    public OracleJsonParser createJsonTextParser(InputStream in) throws OracleJsonException {
        return new JsonParserImpl(in, this.bufferPool);
    }

    public OracleJsonParser createJsonTextParser(Reader in) throws OracleJsonException {
        return new JsonParserImpl(in, this.bufferPool);
    }

    public OracleJsonParser createJsonBinaryParser(ByteBuffer in) throws OracleJsonException {
        OsonContext ctx = new OsonContext(new OsonBuffer(in));
        return new OsonParserImpl(ctx);
    }

    public OracleJsonValue createJsonBinaryValue(InputStream in) throws OracleJsonException {
        byte[] bytes = OracleJsonFactory.readInputStream(in);
        ByteBuffer b = ByteBuffer.wrap(bytes);
        return this.createJsonBinaryValue(b);
    }

    public OracleJsonValue createJsonTextValue(InputStream in) throws OracleJsonException {
        try (OracleJsonParser parser = this.createJsonTextParser(in);){
            parser.next();
            OracleJsonValue oracleJsonValue = parser.getValue();
            return oracleJsonValue;
        }
    }

    public OracleJsonValue createJsonTextValue(Reader in) throws OracleJsonException {
        try (OracleJsonParser parser = this.createJsonTextParser(in);){
            parser.next();
            OracleJsonValue oracleJsonValue = parser.getValue();
            return oracleJsonValue;
        }
    }

    public OracleJsonValue createJsonBinaryValue(ByteBuffer in) throws OracleJsonException {
        OsonContext ctx = new OsonContext(new OsonBuffer(in));
        int offset = ctx.getHeader().getTreeSegmentOffset();
        return (OracleJsonValue)OsonStructureImpl.getValueInternal(offset, ctx.getFactory(), ctx);
    }

    public final OracleJsonGenerator createJsonBinaryGenerator(OutputStream out) {
        return new OsonGeneratorImpl(this.generatorPool, out);
    }

    public OracleJsonGenerator createJsonTextGenerator(OutputStream out) {
        return new JsonSerializerImpl(out);
    }

    public OracleJsonGenerator createJsonTextGenerator(Writer out) {
        return new JsonSerializerImpl(out);
    }

    public OracleJsonObject createObject() {
        return new OracleJsonObjectImpl();
    }

    public OracleJsonArray createArray() {
        return new OracleJsonArrayImpl();
    }

    public OracleJsonObject createObject(OracleJsonObject other) {
        return new OracleJsonObjectImpl(other);
    }

    public OracleJsonArray createArray(OracleJsonArray other) {
        return new OracleJsonArrayImpl(other);
    }

    public OracleJsonString createString(String value) {
        return new OracleJsonStringImpl(value);
    }

    public OracleJsonDecimal createDecimal(BigDecimal value) throws OracleJsonException {
        return new OracleJsonDecimalImpl(value);
    }

    public OracleJsonDecimal createDecimal(int value) {
        return new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.INT);
    }

    public OracleJsonDecimal createDecimal(long value) {
        return new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.LONG);
    }

    public OracleJsonFloat createFloat(float value) {
        return new OracleJsonFloatImpl(value);
    }

    public OracleJsonDouble createDouble(double value) {
        return new OracleJsonDoubleImpl(value);
    }

    public OracleJsonBinary createBinary(byte[] value) {
        return new OracleJsonBinaryImpl(value, false);
    }

    public OracleJsonValue createBoolean(boolean value) {
        return value ? OracleJsonValue.TRUE : OracleJsonValue.FALSE;
    }

    public OracleJsonValue createNull() {
        return OracleJsonValue.NULL;
    }

    public OracleJsonTimestamp createTimestamp(LocalDateTime value) {
        return new OracleJsonTimestampImpl(value);
    }

    public OracleJsonDate createDate(LocalDateTime i) {
        return new OracleJsonDateImpl(i);
    }

    public OracleJsonTimestampTZ createTimestampTZ(OffsetDateTime i) {
        return new OracleJsonTimestampTZImpl(i);
    }

    public OracleJsonIntervalDS createIntervalDS(Duration d) {
        return new OracleJsonIntervalDSImpl(d);
    }

    public OracleJsonIntervalYM createIntervalYM(Period p) {
        return new OracleJsonIntervalYMImpl(p);
    }

    public OracleJsonValue createValue(Datum datum) {
        try {
            if (datum instanceof CHAR) {
                return new OracleJsonStringImpl(datum.stringValue());
            }
            if (datum instanceof NUMBER) {
                return new OracleJsonDecimalImpl(datum.getBytes(), null);
            }
            if (datum instanceof BINARY_DOUBLE) {
                return new OracleJsonDoubleImpl(datum.doubleValue());
            }
            if (datum instanceof BINARY_FLOAT) {
                return new OracleJsonFloatImpl(datum.floatValue());
            }
            if (datum instanceof RAW) {
                return new OracleJsonBinaryImpl(datum.getBytes(), false);
            }
            if (datum instanceof DATE) {
                return new OracleJsonDateImpl(datum.getBytes());
            }
            if (datum instanceof TIMESTAMP) {
                return new OracleJsonTimestampImpl(datum.getBytes());
            }
            if (datum instanceof INTERVALDS) {
                return new OracleJsonIntervalDSImpl(datum.getBytes());
            }
            if (datum instanceof INTERVALYM) {
                return new OracleJsonIntervalYMImpl(datum.getBytes());
            }
            if (datum instanceof OracleJsonDatum) {
                OracleJsonDatum jdatum = (OracleJsonDatum)datum;
                return this.createJsonBinaryValue(ByteBuffer.wrap(jdatum.shareBytes()));
            }
            if (datum instanceof TIMESTAMPTZ) {
                return new OracleJsonTimestampTZImpl(datum.getBytes());
            }
            throw new UnsupportedOperationException();
        }
        catch (SQLException e) {
            throw new OracleJsonException(e.getMessage(), e);
        }
    }

    private static byte[] readInputStream(InputStream in) throws OracleJsonException {
        try {
            int n;
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((n = in.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
            in.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(OracleJsonExceptions.ORACLE_FACTORY, e, new Object[0]);
        }
    }
}

