/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Experimental;
import io.trino.spi.function.table.Preconditions;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Experimental(eta="2022-10-31")
public class Descriptor {
    private final List<Field> fields;

    @JsonCreator
    public Descriptor(@JsonProperty(value="fields") List<Field> fields) {
        Objects.requireNonNull(fields, "fields is null");
        Preconditions.checkArgument(!fields.isEmpty(), "descriptor has no fields");
        this.fields = List.copyOf(fields);
    }

    public static Descriptor descriptor(String ... names) {
        List<Field> fields = Arrays.stream(names).map(name -> new Field((String)name, Optional.empty())).collect(Collectors.toList());
        return new Descriptor(fields);
    }

    public static Descriptor descriptor(List<String> names, List<Type> types) {
        Objects.requireNonNull(names, "names is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument(names.size() == types.size(), "names and types lists do not match");
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < names.size(); ++i) {
            fields.add(new Field(names.get(i), Optional.of(types.get(i))));
        }
        return new Descriptor(fields);
    }

    @JsonProperty
    public List<Field> getFields() {
        return this.fields;
    }

    public boolean isTyped() {
        return this.fields.stream().allMatch(field -> field.type.isPresent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return this.fields.equals(that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public static class Field {
        private final Optional<String> name;
        private final Optional<Type> type;

        public Field(String name, Optional<Type> type) {
            this(Optional.of(name), type);
        }

        @JsonCreator
        public Field(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="type") Optional<Type> type) {
            this.name = Objects.requireNonNull(name, "name is null");
            name.ifPresent(nameValue -> Preconditions.checkArgument(!nameValue.isEmpty(), "name is empty"));
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public Optional<String> getName() {
            return this.name;
        }

        @JsonProperty
        public Optional<Type> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.name.equals(field.name) && this.type.equals(field.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

