/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TimeZoneKey;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;

enum ToStringSession implements ConnectorSession
{
    INSTANCE;


    @Override
    public String getQueryId() {
        return "to_string";
    }

    @Override
    public Optional<String> getSource() {
        return Optional.of("to_string");
    }

    @Override
    public ConnectorIdentity getIdentity() {
        return ConnectorIdentity.ofUser("to_string");
    }

    @Override
    public TimeZoneKey getTimeZoneKey() {
        return TimeZoneKey.UTC_KEY;
    }

    @Override
    public Locale getLocale() {
        return Locale.ENGLISH;
    }

    @Override
    public Instant getStart() {
        return Instant.ofEpochMilli(0L);
    }

    @Override
    public Optional<String> getTraceToken() {
        return Optional.empty();
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property '%s' does not exist".formatted(name));
    }
}

