/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface SystemAccessControl {
    default public void checkCanImpersonateUser(Identity identity, String userName) {
        AccessDeniedException.denyImpersonateUser(identity.getUser(), userName);
    }

    @Deprecated
    default public void checkCanSetUser(Optional<Principal> principal, String userName) {
        AccessDeniedException.denySetUser(principal, userName);
    }

    default public void checkCanExecuteQuery(Identity identity, QueryId queryId) {
        AccessDeniedException.denyExecuteQuery();
    }

    default public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        AccessDeniedException.denyViewQuery();
    }

    default public Collection<Identity> filterViewQueryOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        return Collections.emptySet();
    }

    default public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        AccessDeniedException.denyKillQuery();
    }

    default public void checkCanReadSystemInformation(Identity identity) {
        AccessDeniedException.denyReadSystemInformationAccess();
    }

    default public void checkCanWriteSystemInformation(Identity identity) {
        AccessDeniedException.denyWriteSystemInformationAccess();
    }

    default public void checkCanSetSystemSessionProperty(Identity identity, QueryId queryId, String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty(propertyName);
    }

    default public boolean canAccessCatalog(SystemSecurityContext context, String catalogName) {
        return false;
    }

    default public void checkCanCreateCatalog(SystemSecurityContext context, String catalog) {
        AccessDeniedException.denyCreateCatalog(catalog);
    }

    default public void checkCanDropCatalog(SystemSecurityContext context, String catalog) {
        AccessDeniedException.denyDropCatalog(catalog);
    }

    default public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return Collections.emptySet();
    }

    default public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema, Map<String, Object> properties) {
        AccessDeniedException.denyCreateSchema(schema.toString());
    }

    default public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyDropSchema(schema.toString());
    }

    default public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schema.toString(), newSchemaName);
    }

    @Deprecated(forRemoval=true)
    default public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        AccessDeniedException.denySetEntityAuthorization(new EntityKindAndName("SCHEMA", List.of(schema.getCatalogName(), schema.getSchemaName())), principal);
    }

    default public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    default public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return Collections.emptySet();
    }

    default public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyShowCreateSchema(schemaName.toString());
    }

    default public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyShowCreateTable(table.toString());
    }

    default public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        AccessDeniedException.denyCreateTable(table.toString());
    }

    default public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropTable(table.toString());
    }

    default public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        AccessDeniedException.denyRenameTable(table.toString(), newTable.toString());
    }

    default public void checkCanSetTableProperties(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetTableProperties(table.toString());
    }

    default public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyCommentTable(table.toString());
    }

    default public void checkCanSetViewComment(SystemSecurityContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyCommentView(view.toString());
    }

    default public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyCommentColumn(table.toString());
    }

    default public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTables(schema.toString());
    }

    default public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return Collections.emptySet();
    }

    default public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyShowColumns(table.toString());
    }

    @Deprecated
    default public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        return Collections.emptySet();
    }

    default public Map<SchemaTableName, Set<String>> filterColumns(SystemSecurityContext context, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        return tableColumns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.filterColumns(context, new CatalogSchemaTableName(catalogName, (SchemaTableName)entry.getKey()), (Set)entry.getValue())));
    }

    default public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyAddColumn(table.toString());
    }

    default public void checkCanAlterColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyAlterColumn(table.toString());
    }

    default public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropColumn(table.toString());
    }

    @Deprecated(forRemoval=true)
    default public void checkCanSetTableAuthorization(SystemSecurityContext context, CatalogSchemaTableName table, TrinoPrincipal principal) {
        AccessDeniedException.denySetEntityAuthorization(new EntityKindAndName("TABLE", List.of(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName())), principal);
    }

    default public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyRenameColumn(table.toString());
    }

    default public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denySelectColumns(table.toString(), columns);
    }

    default public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyInsertTable(table.toString());
    }

    default public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDeleteTable(table.toString());
    }

    default public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyTruncateTable(table.toString());
    }

    default public void checkCanUpdateTableColumns(SystemSecurityContext securityContext, CatalogSchemaTableName table, Set<String> updatedColumnNames) {
        AccessDeniedException.denyUpdateTableColumns(table.toString(), updatedColumnNames);
    }

    default public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyCreateView(view.toString());
    }

    default public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        AccessDeniedException.denyRenameTable(view.toString(), newView.toString());
    }

    @Deprecated(forRemoval=true)
    default public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        AccessDeniedException.denySetEntityAuthorization(new EntityKindAndName("VIEW", List.of(view.getCatalogName(), view.getSchemaTableName().getSchemaName(), view.getSchemaTableName().getTableName())), principal);
    }

    default public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyDropView(view.toString());
    }

    default public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denyCreateViewWithSelect(table.toString(), context.getIdentity());
    }

    default public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        AccessDeniedException.denyCreateMaterializedView(materializedView.toString());
    }

    default public void checkCanRefreshMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        AccessDeniedException.denyRefreshMaterializedView(materializedView.toString());
    }

    default public void checkCanSetMaterializedViewProperties(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetMaterializedViewProperties(materializedView.toString());
    }

    default public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        AccessDeniedException.denyDropMaterializedView(materializedView.toString());
    }

    default public void checkCanRenameMaterializedView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        AccessDeniedException.denyRenameMaterializedView(view.toString(), newView.toString());
    }

    default public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantSchemaPrivilege(privilege.toString(), schema.toString());
    }

    default public void checkCanDenySchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenySchemaPrivilege(privilege.toString(), schema.toString());
    }

    default public void checkCanRevokeSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeSchemaPrivilege(privilege.toString(), schema.toString());
    }

    default public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanDenyTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenyTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanGrantEntityPrivilege(SystemSecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantEntityPrivilege(privilege.toString(), entity);
    }

    default public void checkCanDenyEntityPrivilege(SystemSecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenyEntityPrivilege(privilege.toString(), entity);
    }

    default public void checkCanRevokeEntityPrivilege(SystemSecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeEntityPrivilege(privilege.toString(), entity);
    }

    default public void checkCanShowRoles(SystemSecurityContext context) {
        AccessDeniedException.denyShowRoles();
    }

    default public void checkCanCreateRole(SystemSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyCreateRole(role);
    }

    default public void checkCanDropRole(SystemSecurityContext context, String role) {
        AccessDeniedException.denyDropRole(role);
    }

    default public void checkCanGrantRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    default public void checkCanRevokeRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    default public void checkCanShowCurrentRoles(SystemSecurityContext context) {
        AccessDeniedException.denyShowCurrentRoles();
    }

    default public void checkCanShowRoleGrants(SystemSecurityContext context) {
        AccessDeniedException.denyShowRoleGrants();
    }

    default public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        AccessDeniedException.denyExecuteProcedure(procedure.toString());
    }

    default public boolean canExecuteFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        return false;
    }

    default public boolean canCreateViewWithExecuteFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        return false;
    }

    default public void checkCanExecuteTableProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaTableName table, String procedure) {
        AccessDeniedException.denyExecuteTableProcedure(table.toString(), procedure);
    }

    default public void checkCanShowFunctions(SystemSecurityContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyShowFunctions(schema.toString());
    }

    default public Set<SchemaFunctionName> filterFunctions(SystemSecurityContext context, String catalogName, Set<SchemaFunctionName> functionNames) {
        return Collections.emptySet();
    }

    default public void checkCanCreateFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        AccessDeniedException.denyCreateFunction(functionName.toString());
    }

    default public void checkCanDropFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        AccessDeniedException.denyDropFunction(functionName.toString());
    }

    default public void checkCanShowCreateFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        AccessDeniedException.denyShowCreateFunction(functionName.toString());
    }

    default public List<ViewExpression> getRowFilters(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        return List.of();
    }

    @Deprecated
    default public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }

    default public void checkCanSetEntityAuthorization(SystemSecurityContext context, EntityKindAndName entityKindAndName, TrinoPrincipal principal) {
        String kind = entityKindAndName.entityKind().toUpperCase(Locale.ENGLISH);
        List<String> name = entityKindAndName.name();
        switch (kind) {
            case "SCHEMA": {
                if (name.size() != 2) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "The schema name %s must have two elements".formatted(name));
                }
                this.checkCanSetSchemaAuthorization(context, new CatalogSchemaName(name.get(0), name.get(1)), principal);
                break;
            }
            case "TABLE": {
                if (name.size() != 3) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "The table name %s must have three elements".formatted(name));
                }
                this.checkCanSetTableAuthorization(context, new CatalogSchemaTableName(name.get(0), name.get(1), name.get(2)), principal);
                break;
            }
            case "VIEW": {
                if (name.size() != 3) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "The view name %s must have three elements".formatted(name));
                }
                this.checkCanSetViewAuthorization(context, new CatalogSchemaTableName(name.get(0), name.get(1), name.get(2)), principal);
                break;
            }
            default: {
                AccessDeniedException.denySetEntityAuthorization(new EntityKindAndName(kind, name), principal);
            }
        }
    }

    default public Map<ColumnSchema, ViewExpression> getColumnMasks(SystemSecurityContext context, CatalogSchemaTableName tableName, List<ColumnSchema> columns) {
        return columns.stream().map(column -> Map.entry(column, this.getColumnMask(context, tableName, column.getName(), column.getType()))).filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (ViewExpression)((Optional)entry.getValue()).get()));
    }

    default public Iterable<EventListener> getEventListeners() {
        return Collections.emptySet();
    }

    default public void shutdown() {
    }
}

