/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.connector.CatalogSchemaName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ViewExpression {
    private final Optional<String> identity;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final String expression;
    private final List<CatalogSchemaName> path;

    private ViewExpression(Optional<String> identity, Optional<String> catalog, Optional<String> schema, String expression, List<CatalogSchemaName> path) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.path = List.copyOf(path);
        if (catalog.isEmpty() && schema.isPresent()) {
            throw new IllegalArgumentException("catalog must be present if schema is present");
        }
    }

    public Optional<String> getSecurityIdentity() {
        return this.identity;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public String getExpression() {
        return this.expression;
    }

    public List<CatalogSchemaName> getPath() {
        return this.path;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String identity;
        private String catalog;
        private String schema;
        private String expression;
        private List<CatalogSchemaName> path = List.of();

        private Builder() {
        }

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public void setPath(List<CatalogSchemaName> path) {
            this.path = List.copyOf(path);
        }

        public ViewExpression build() {
            return new ViewExpression(Optional.ofNullable(this.identity), Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.expression, this.path);
        }
    }
}

