/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigInteger;
import java.nio.ByteOrder;

final class LongDecimalType
extends DecimalType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongDecimalType.class, MethodHandles.lookup(), Int128.class);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);

    LongDecimalType(int precision, int scale) {
        super(precision, scale, Int128.class, Int128ArrayBlock.class);
        LongDecimalType.checkArgument(18 < precision && precision <= 38, "Invalid precision: %s", precision);
        LongDecimalType.checkArgument(0 <= scale && scale <= precision, "Invalid scale for precision %s: %s", precision, scale);
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 16;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Int128 value = this.getObject(block, position);
        BigInteger unscaledValue = value.toBigInteger();
        return new SqlDecimal(unscaledValue, this.getPrecision(), this.getScale());
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            Int128ArrayBlock valueBlock = (Int128ArrayBlock)block.getUnderlyingValueBlock();
            int valuePosition = block.getUnderlyingValuePosition(position);
            ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(valueBlock.getInt128High(valuePosition), valueBlock.getInt128Low(valuePosition));
        }
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        Int128 decimal = (Int128)value;
        ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(decimal.getHigh(), decimal.getLow());
    }

    @Override
    public Int128 getObject(Block block, int position) {
        return LongDecimalType.read((Int128ArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public int getFlatFixedSize() {
        return 16;
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static Int128 read(@BlockPosition Int128ArrayBlock block, @BlockIndex int position) {
        return block.getInt128(position);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static Int128 readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, @FlatVariableOffset int unusedVariableSizeOffset) {
        return Int128.valueOf(LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset), LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 8));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void readFlatToBlock(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, @FlatVariableOffset int unusedVariableSizeOffset, BlockBuilder blockBuilder) {
        ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset), LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 8));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(Int128 value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset, value.getHigh());
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 8, value.getLow());
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeBlockToFlat(@BlockPosition Int128ArrayBlock block, @BlockIndex int position, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset, block.getInt128High(position));
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 8, block.getInt128Low(position));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Int128 left, Int128 right) {
        return left.equals(right);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Int128ArrayBlock leftBlock, @BlockIndex int leftPosition, @BlockPosition Int128ArrayBlock rightBlock, @BlockIndex int rightPosition) {
        return leftBlock.getInt128High(leftPosition) == rightBlock.getInt128High(rightPosition) && leftBlock.getInt128Low(leftPosition) == rightBlock.getInt128Low(rightPosition);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Int128 value) {
        return LongDecimalType.xxHash64(value.getHigh(), value.getLow());
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Int128ArrayBlock block, @BlockIndex int position) {
        return LongDecimalType.xxHash64(block.getInt128High(position), block.getInt128Low(position));
    }

    private static long xxHash64(long high, long low) {
        return XxHash64.hash((long)high) ^ XxHash64.hash((long)low);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(Int128 left, Int128 right) {
        return left.compareTo(right);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Int128ArrayBlock leftBlock, @BlockIndex int leftPosition, @BlockPosition Int128ArrayBlock rightBlock, @BlockIndex int rightPosition) {
        return Int128.compare(leftBlock.getInt128High(leftPosition), leftBlock.getInt128Low(leftPosition), rightBlock.getInt128High(rightPosition), rightBlock.getInt128Low(rightPosition));
    }
}

