/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.ShortArrayBlock;
import io.trino.spi.block.ShortArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class SmallintType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(SmallintType.class, MethodHandles.lookup(), Long.TYPE);
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    public static final SmallintType SMALLINT = new SmallintType();

    private SmallintType() {
        super(new TypeSignature("smallint", new TypeSignatureParameter[0]), Long.TYPE, ShortArrayBlock.class);
    }

    @Override
    public int getFixedSize() {
        return 2;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ShortArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 2));
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ShortArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return this.getShort(block, position);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(-32768L, 32767L));
    }

    @Override
    public Optional<Object> getPreviousValue(Object object) {
        long value = (Long)object;
        this.checkValueValid(value);
        if (value == -32768L) {
            return Optional.empty();
        }
        return Optional.of(value - 1L);
    }

    @Override
    public Optional<Object> getNextValue(Object object) {
        long value = (Long)object;
        this.checkValueValid(value);
        if (value == 32767L) {
            return Optional.empty();
        }
        return Optional.of(value + 1L);
    }

    @Override
    public Optional<Stream<?>> getDiscreteValues(Type.Range range) {
        return Optional.of(LongStream.rangeClosed((Long)range.getMin(), (Long)range.getMax()).boxed());
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            ((ShortArrayBlockBuilder)blockBuilder).writeShort(this.getShort(block, position));
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return this.getShort(block, position);
    }

    public short getShort(Block block, int position) {
        return SmallintType.readShort((ShortArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        this.checkValueValid(value);
        this.writeShort(blockBuilder, (short)value);
    }

    public void writeShort(BlockBuilder blockBuilder, short value) {
        ((ShortArrayBlockBuilder)blockBuilder).writeShort(value);
    }

    private void checkValueValid(long value) {
        if (value > 32767L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_SHORT for type %s", value, this.getTypeSignature()));
        }
        if (value < -32768L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_SHORT for type %s", value, this.getTypeSignature()));
        }
    }

    @Override
    public int getFlatFixedSize() {
        return 2;
    }

    @Override
    public boolean equals(Object other) {
        return other == SMALLINT;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long read(@BlockPosition ShortArrayBlock block, @BlockIndex int position) {
        return SmallintType.readShort(block, position);
    }

    private static short readShort(ShortArrayBlock block, int position) {
        return block.getShort(position);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, @FlatVariableOffset int unusedVariableSizeOffset) {
        return SHORT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(long value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        SHORT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, (short)value);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        return AbstractLongType.hash((short)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        return XxHash64.hash((long)((short)value));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Short.compare((short)left, (short)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return (short)left < (short)right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return (short)left <= (short)right;
    }
}

