/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public interface Type {
    public TypeSignature getTypeSignature();

    @JsonValue
    default public TypeId getTypeId() {
        return TypeId.of(this.getTypeSignature().toString());
    }

    default public String getBaseName() {
        return this.getTypeSignature().getBase();
    }

    public String getDisplayName();

    public boolean isComparable();

    public boolean isOrderable();

    default public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TypeOperatorDeclaration.NO_TYPE_OPERATOR_DECLARATION;
    }

    public Class<?> getJavaType();

    public Class<? extends ValueBlock> getValueBlockType();

    public List<Type> getTypeParameters();

    public BlockBuilder createBlockBuilder(BlockBuilderStatus var1, int var2, int var3);

    public BlockBuilder createBlockBuilder(BlockBuilderStatus var1, int var2);

    default public ValueBlock createNullBlock() {
        return this.createBlockBuilder(null, 1, 0).appendNull().buildValueBlock();
    }

    public Object getObjectValue(ConnectorSession var1, Block var2, int var3);

    public boolean getBoolean(Block var1, int var2);

    public long getLong(Block var1, int var2);

    public double getDouble(Block var1, int var2);

    public Slice getSlice(Block var1, int var2);

    public Object getObject(Block var1, int var2);

    public void writeBoolean(BlockBuilder var1, boolean var2);

    public void writeLong(BlockBuilder var1, long var2);

    public void writeDouble(BlockBuilder var1, double var2);

    public void writeSlice(BlockBuilder var1, Slice var2);

    public void writeSlice(BlockBuilder var1, Slice var2, int var3, int var4);

    public void writeObject(BlockBuilder var1, Object var2);

    public void appendTo(Block var1, int var2, BlockBuilder var3);

    default public Optional<Range> getRange() {
        return Optional.empty();
    }

    default public Optional<Object> getPreviousValue(Object value) {
        if (!this.isOrderable()) {
            throw new IllegalStateException("Type is not orderable: " + String.valueOf(this));
        }
        Objects.requireNonNull(value, "value is null");
        return Optional.empty();
    }

    default public Optional<Object> getNextValue(Object value) {
        if (!this.isOrderable()) {
            throw new IllegalStateException("Type is not orderable: " + String.valueOf(this));
        }
        Objects.requireNonNull(value, "value is null");
        return Optional.empty();
    }

    default public Optional<Stream<?>> getDiscreteValues(Range range) {
        return Optional.empty();
    }

    public int getFlatFixedSize();

    public boolean isFlatVariableWidth();

    public int getFlatVariableWidthSize(Block var1, int var2);

    public int getFlatVariableWidthLength(byte[] var1, int var2);

    public static final class Range {
        private final Object min;
        private final Object max;

        public Range(Object min, Object max) {
            this.min = Objects.requireNonNull(min, "min is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        public Object getMin() {
            return this.min;
        }

        public Object getMax() {
            return this.max;
        }
    }
}

