/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Locale;

public class DefaultIdentifierMapping
implements IdentifierMapping {
    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        return remoteSchemaName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        return remoteTableName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return remoteColumnName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String toRemoteSchemaName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String schemaName) {
        return this.toRemoteIdentifier(schemaName, remoteIdentifiers);
    }

    @Override
    public String toRemoteTableName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String remoteSchema, String tableName) {
        return this.toRemoteIdentifier(tableName, remoteIdentifiers);
    }

    @Override
    public String toRemoteColumnName(RemoteIdentifiers remoteIdentifiers, String columnName) {
        return this.toRemoteIdentifier(columnName, remoteIdentifiers);
    }

    private String toRemoteIdentifier(String identifier, RemoteIdentifiers remoteIdentifiers) {
        if (remoteIdentifiers.storesUpperCaseIdentifiers()) {
            return identifier.toUpperCase(Locale.ENGLISH);
        }
        return identifier;
    }
}

